/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2.audit.iti31;

import ca.uhn.hl7v2.model.Message;
import java.util.Map;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;
import org.openehealth.ipf.commons.ihe.core.atna.AuditDataset;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategySupport;
import org.openehealth.ipf.commons.ihe.core.atna.event.PatientRecordEventBuilder;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.FeedAuditDataset;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.codes.MllpEventTypeCode;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.iti31.Iti31AuditStrategyUtils;

public class Iti31AuditStrategy
extends AuditStrategySupport<FeedAuditDataset> {
    public Iti31AuditStrategy(boolean serverSide) {
        super(serverSide);
    }

    public FeedAuditDataset enrichAuditDatasetFromRequest(FeedAuditDataset auditDataset, Object msg, Map<String, Object> parameters) {
        Iti31AuditStrategyUtils.enrichAuditDatasetFromRequest(auditDataset, (Message)msg);
        return auditDataset;
    }

    public AuditMessage[] makeAuditMessage(AuditContext auditContext, FeedAuditDataset auditDataset) {
        switch (auditDataset.getMessageType()) {
            case "A01": 
            case "A04": 
            case "A05": {
                return new AuditMessage[]{this.patientRecordAuditMessage(auditContext, auditDataset, EventActionCode.Create, true)};
            }
            case "A02": 
            case "A03": 
            case "A06": 
            case "A07": 
            case "A08": 
            case "A09": 
            case "A10": 
            case "A12": 
            case "A13": 
            case "A14": 
            case "A15": 
            case "A16": 
            case "A25": 
            case "A26": 
            case "A27": 
            case "A32": 
            case "A33": 
            case "A38": 
            case "A44": 
            case "A52": 
            case "A53": 
            case "A54": 
            case "A55": 
            case "Z99": {
                return new AuditMessage[]{this.patientRecordAuditMessage(auditContext, auditDataset, EventActionCode.Update, true)};
            }
            case "A40": {
                return new AuditMessage[]{this.patientRecordAuditMessage(auditContext, auditDataset, EventActionCode.Delete, false), this.patientRecordAuditMessage(auditContext, auditDataset, EventActionCode.Update, true)};
            }
            case "A41": {
                return new AuditMessage[]{this.patientRecordAuditMessage(auditContext, auditDataset, EventActionCode.Delete, true)};
            }
        }
        throw new AuditException("Cannot create audit message for event " + auditDataset.getMessageType());
    }

    protected AuditMessage patientRecordAuditMessage(AuditContext auditContext, FeedAuditDataset auditDataset, EventActionCode eventActionCode, boolean newPatientId) {
        return new PatientRecordEventBuilder(auditContext, (AuditDataset)auditDataset, eventActionCode, (EventType)MllpEventTypeCode.PatientIdentityManagement, new PurposeOfUse[0]).addPatients("MSH-10", auditDataset.getMessageControlId(), new String[]{newPatientId ? auditDataset.getPatientId() : auditDataset.getOldPatientId()}).getMessage();
    }

    public FeedAuditDataset createAuditDataset() {
        return new FeedAuditDataset(this.isServerSide());
    }
}

