/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2.audit;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.openehealth.ipf.commons.audit.utils.AuditUtils;
import org.openehealth.ipf.commons.ihe.core.atna.AuditDataset;

public abstract class MllpAuditDataset
extends AuditDataset {
    private static final long serialVersionUID = -4427222097816361541L;
    private String sendingApplication;
    private String sendingFacility;
    private String receivingApplication;
    private String receivingFacility;
    private String messageType;
    private String messageControlId;
    private String localAddress;
    private String remoteAddress;

    public MllpAuditDataset(boolean serverSide) {
        super(serverSide);
    }

    public String getSourceUserId() {
        return String.format("%s|%s", this.sendingFacility, this.sendingApplication);
    }

    public String getDestinationUserId() {
        return String.format("%s|%s", this.receivingFacility, this.receivingApplication);
    }

    public String getLocalAddress() {
        return this.localAddress != null ? this.localAddress : AuditUtils.getLocalIPAddress();
    }

    public List<AuditDataset.HumanUser> getHumanUsers() {
        return Collections.emptyList();
    }

    @Generated
    public String getSendingApplication() {
        return this.sendingApplication;
    }

    @Generated
    public void setSendingApplication(String sendingApplication) {
        this.sendingApplication = sendingApplication;
    }

    @Generated
    public String getSendingFacility() {
        return this.sendingFacility;
    }

    @Generated
    public void setSendingFacility(String sendingFacility) {
        this.sendingFacility = sendingFacility;
    }

    @Generated
    public String getReceivingApplication() {
        return this.receivingApplication;
    }

    @Generated
    public void setReceivingApplication(String receivingApplication) {
        this.receivingApplication = receivingApplication;
    }

    @Generated
    public String getReceivingFacility() {
        return this.receivingFacility;
    }

    @Generated
    public void setReceivingFacility(String receivingFacility) {
        this.receivingFacility = receivingFacility;
    }

    @Generated
    public String getMessageType() {
        return this.messageType;
    }

    @Generated
    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    @Generated
    public String getMessageControlId() {
        return this.messageControlId;
    }

    @Generated
    public void setMessageControlId(String messageControlId) {
        this.messageControlId = messageControlId;
    }

    @Generated
    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    @Generated
    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Generated
    public String getRemoteAddress() {
        return this.remoteAddress;
    }
}

