/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.util.Terser;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2AcceptanceException;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2TransactionConfiguration;
import org.openehealth.ipf.commons.ihe.hl7v2.NakFactory;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.QueryAuditDataset;
import org.openehealth.ipf.modules.hl7.message.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QpdAwareNakFactory
extends NakFactory<QueryAuditDataset> {
    private static final Logger LOG = LoggerFactory.getLogger(QpdAwareNakFactory.class);
    private final String messageType;
    private final String triggerEvent;

    public QpdAwareNakFactory(Hl7v2TransactionConfiguration<QueryAuditDataset> config, String messageType, String triggerEvent) {
        super(config);
        Validate.notEmpty((CharSequence)messageType);
        Validate.notEmpty((CharSequence)triggerEvent);
        this.messageType = messageType;
        this.triggerEvent = triggerEvent;
    }

    @Override
    public Message createNak(Message originalMessage, HL7Exception t, AcknowledgmentCode ackTypeCode) {
        try {
            return t instanceof Hl7v2AcceptanceException ? super.createNak(originalMessage, t, ackTypeCode) : this.createNak0(originalMessage, t, ackTypeCode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Message createNak0(Message originalMessage, HL7Exception e, AcknowledgmentCode ackTypeCode) throws HL7Exception {
        AbstractMessage ack = (AbstractMessage)MessageUtils.response((Message)originalMessage, (String)this.messageType, (String)this.triggerEvent);
        LOG.info("Creating NAK response event of type {}", (Object)ack.getClass().getName());
        e.populateResponse((Message)ack, ackTypeCode, 0);
        Segment msa = (Segment)ack.get("MSA");
        Terser.set((Segment)msa, (int)1, (int)0, (int)1, (int)1, (String)ackTypeCode.name());
        Segment ackQak = (Segment)ack.get("QAK");
        Segment origQpd = (Segment)originalMessage.get("QPD");
        if (origQpd != null) {
            String queryTag = Terser.get((Segment)origQpd, (int)2, (int)0, (int)1, (int)1);
            Terser.set((Segment)ackQak, (int)1, (int)0, (int)1, (int)1, (String)queryTag);
            LOG.debug("Set QAK-1 to {}", (Object)queryTag);
        }
        Terser.set((Segment)ackQak, (int)2, (int)0, (int)1, (int)1, (String)"AE");
        Segment ackQpd = (Segment)ack.get("QPD");
        Terser.set((Segment)ackQpd, (int)1, (int)0, (int)1, (int)1, (String)"dummy");
        return ack;
    }

    @Override
    public Message createAck(Message originalMessage) {
        throw new IllegalStateException("This transaction cannot return a simple ACK");
    }
}

