/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2;

import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.openehealth.ipf.commons.ihe.core.IntegrationProfile;
import org.openehealth.ipf.commons.ihe.core.InteractionId;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2InteractionId;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2TransactionConfiguration;
import org.openehealth.ipf.commons.ihe.hl7v2.NakFactory;
import org.openehealth.ipf.commons.ihe.hl7v2.PdqTransactionConfiguration;
import org.openehealth.ipf.commons.ihe.hl7v2.QpdAwareNakFactory;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.QueryAuditDataset;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.iti21.Iti21AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.iti22.Iti22AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.CustomModelClassUtils;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.HapiContextFactory;
import org.openehealth.ipf.gazelle.validation.profile.HL7v2Transactions;
import org.openehealth.ipf.gazelle.validation.profile.pixpdq.PixPdqTransactions;

public class PDQ
implements IntegrationProfile {
    private static final Hl7v2TransactionConfiguration<QueryAuditDataset> ITI_21_CONFIGURATION = new PdqTransactionConfiguration("pdq-iti21", "Patient Demographics Query", true, (AuditStrategy<QueryAuditDataset>)new Iti21AuditStrategy(false), (AuditStrategy<QueryAuditDataset>)new Iti21AuditStrategy(true), new Version[]{Version.V25}, "PDQ adapter", "IPF", ErrorCode.APPLICATION_INTERNAL_ERROR, ErrorCode.APPLICATION_INTERNAL_ERROR, new String[]{"QBP", "QCN"}, new String[]{"Q22", "J01"}, new String[]{"RSP", "ACK"}, new String[]{"K22", "*"}, new boolean[]{true, false}, new boolean[]{true, false}, HapiContextFactory.createHapiContext((ModelClassFactory)CustomModelClassUtils.createFactory("pdq", "2.5"), (HL7v2Transactions)PixPdqTransactions.ITI21));
    private static final NakFactory<QueryAuditDataset> ITI_21_NAK_FACTORY = new QpdAwareNakFactory(ITI_21_CONFIGURATION, "RSP", "K22");
    private static final Hl7v2TransactionConfiguration<QueryAuditDataset> ITI_22_CONFIGURATION = new PdqTransactionConfiguration("pdq-iti22", "Patient Demographics And Visit Query", true, (AuditStrategy<QueryAuditDataset>)new Iti22AuditStrategy(false), (AuditStrategy<QueryAuditDataset>)new Iti22AuditStrategy(true), new Version[]{Version.V25}, "PDQ adapter", "IPF", ErrorCode.APPLICATION_INTERNAL_ERROR, ErrorCode.APPLICATION_INTERNAL_ERROR, new String[]{"QBP", "QCN"}, new String[]{"ZV1", "J01"}, new String[]{"RSP", "ACK"}, new String[]{"ZV2", "*"}, new boolean[]{true, false}, new boolean[]{true, false}, HapiContextFactory.createHapiContext((ModelClassFactory)CustomModelClassUtils.createFactory("pdq", "2.5"), (HL7v2Transactions)PixPdqTransactions.ITI22));
    private static final NakFactory<QueryAuditDataset> ITI_22_NAK_FACTORY = new QpdAwareNakFactory(ITI_22_CONFIGURATION, "RSP", "ZV2");

    public List<InteractionId> getInteractionIds() {
        return Arrays.asList(Interactions.values());
    }

    public static enum Interactions implements Hl7v2InteractionId<QueryAuditDataset>
    {
        ITI_21(ITI_21_CONFIGURATION, ITI_21_NAK_FACTORY),
        ITI_22(ITI_22_CONFIGURATION, ITI_22_NAK_FACTORY);

        private final Hl7v2TransactionConfiguration<QueryAuditDataset> hl7v2TransactionConfiguration;
        private final NakFactory<QueryAuditDataset> nakFactory;

        @Generated
        private Interactions(Hl7v2TransactionConfiguration<QueryAuditDataset> hl7v2TransactionConfiguration, NakFactory<QueryAuditDataset> nakFactory) {
            this.hl7v2TransactionConfiguration = hl7v2TransactionConfiguration;
            this.nakFactory = nakFactory;
        }

        @Override
        @Generated
        public Hl7v2TransactionConfiguration<QueryAuditDataset> getHl7v2TransactionConfiguration() {
            return this.hl7v2TransactionConfiguration;
        }

        @Override
        @Generated
        public NakFactory<QueryAuditDataset> getNakFactory() {
            return this.nakFactory;
        }
    }
}

