/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2AcceptanceException;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2TransactionConfiguration;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.MllpAuditDataset;
import org.openehealth.ipf.modules.hl7.message.MessageUtils;

public class NakFactory<AuditDatasetType extends MllpAuditDataset> {
    private final Hl7v2TransactionConfiguration<AuditDatasetType> config;
    private final boolean useCAckTypeCodes;
    private final String defaultNakMsh9;

    public NakFactory(Hl7v2TransactionConfiguration<AuditDatasetType> config, boolean useCAckTypeCodes, String defaultNakMsh9) {
        this.config = Objects.requireNonNull(config);
        this.useCAckTypeCodes = useCAckTypeCodes;
        this.defaultNakMsh9 = Objects.requireNonNull(defaultNakMsh9);
    }

    public NakFactory(Hl7v2TransactionConfiguration<AuditDatasetType> config) {
        this(config, false, "ACK");
    }

    public Message createAck(Message originalMessage) throws HL7Exception, IOException {
        return originalMessage.generateACK(this.useCAckTypeCodes ? AcknowledgmentCode.CA : AcknowledgmentCode.AA, null);
    }

    public Message createNak(Message originalMessage, HL7Exception exception, AcknowledgmentCode ackTypeCode) throws HL7Exception, IOException {
        return originalMessage.generateACK(ackTypeCode, exception);
    }

    public Message createNak(Message originalMessage, Throwable t) throws HL7Exception, IOException {
        HL7Exception hl7Exception = this.getHl7Exception(t);
        return this.createNak(originalMessage, hl7Exception, this.getAckTypeCode(hl7Exception));
    }

    public Message createDefaultNak(HL7Exception e) {
        HL7Exception hl7Exception = new HL7Exception(NakFactory.formatErrorMessage(e), this.config.getRequestErrorDefaultErrorCode(), (Throwable)e);
        return MessageUtils.defaultNak((HL7Exception)hl7Exception, (AcknowledgmentCode)(this.useCAckTypeCodes ? AcknowledgmentCode.CR : AcknowledgmentCode.AR), (String)this.config.getHl7Versions()[0].getVersion(), (String)this.config.getSendingApplication(), (String)this.config.getSendingFacility(), (String)this.defaultNakMsh9);
    }

    protected HL7Exception getHl7Exception(Throwable t) {
        return NakFactory.getException(HL7Exception.class, t).orElseGet(() -> new HL7Exception(NakFactory.formatErrorMessage(t), this.config.getRequestErrorDefaultErrorCode(), t));
    }

    protected AcknowledgmentCode getAckTypeCode(Throwable t) {
        AcknowledgmentCode ackTypeCode;
        AcknowledgmentCode acknowledgmentCode = ackTypeCode = t instanceof Hl7v2AcceptanceException ? AcknowledgmentCode.AR : AcknowledgmentCode.AE;
        if (this.useCAckTypeCodes) {
            ackTypeCode = ackTypeCode == AcknowledgmentCode.AR ? AcknowledgmentCode.CR : AcknowledgmentCode.CE;
        }
        return ackTypeCode;
    }

    public static String formatErrorMessage(Throwable t) {
        String s = t.getMessage();
        if (s == null) {
            s = t.getClass().getName();
        }
        s = s.replace('\n', ';');
        s = s.replace('\r', ';');
        return s;
    }

    protected Hl7v2TransactionConfiguration<AuditDatasetType> getConfig() {
        return this.config;
    }

    private static <T extends Throwable> Optional<T> getException(Class<T> type, Throwable exception) {
        if (exception == null) {
            return Optional.empty();
        }
        Optional<T> result = NakFactory.identifyException(Stream.of(exception.getSuppressed()), type);
        if (result.isPresent()) {
            return result;
        }
        return NakFactory.createExceptionStream(exception).filter(type::isInstance).map(type::cast).findFirst();
    }

    private static <T extends Throwable> Optional<T> identifyException(Stream<Throwable> stream, Class<T> type) {
        return stream.filter(type::isInstance).map(type::cast).findFirst();
    }

    private static Stream<Throwable> createExceptionStream(Throwable exception) {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        for (Throwable current = exception; current != null; current = current.getCause()) {
            throwables.add(current);
        }
        Collections.reverse(throwables);
        return throwables.stream();
    }
}

