/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.openehealth.ipf.commons.ihe.core.TransactionOptions;

public interface Hl7v2TransactionOptions
extends TransactionOptions<String> {
    public static List<String> concat(Hl7v2TransactionOptions options, List<String> suffix) {
        if (suffix != null && !suffix.isEmpty()) {
            HashSet<String> events = new HashSet<String>(options.getSupportedThings());
            events.addAll(suffix);
            return new ArrayList<String>(events);
        }
        return options.getSupportedThings();
    }

    public static List<String> concat(Hl7v2TransactionOptions option, Hl7v2TransactionOptions otherOption, List<String> suffix) {
        List<String> events = Hl7v2TransactionOptions.concat(otherOption, suffix);
        return Hl7v2TransactionOptions.concat(option, events);
    }

    public static <T extends Hl7v2TransactionOptions> String concatAllToString(List<? extends T> options) {
        return options.stream().flatMap(o -> o.getSupportedThings().stream()).distinct().map(Object::toString).collect(Collectors.joining(" "));
    }
}

