/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2;

import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.util.Terser;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.core.TransactionConfiguration;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2AcceptanceException;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.MllpAuditDataset;
import org.openehealth.ipf.modules.hl7.HL7v2Exception;
import org.openehealth.ipf.modules.hl7.message.MessageUtils;

public class Hl7v2TransactionConfiguration<AuditDatasetType extends MllpAuditDataset>
extends TransactionConfiguration<AuditDatasetType> {
    private final String sendingApplication;
    private final String sendingFacility;
    private final ErrorCode requestErrorDefaultErrorCode;
    private final ErrorCode responseErrorDefaultErrorCode;
    private final HapiContext hapiContext;
    private final String[] allowedRequestMessageTypes;
    private final String[] allowedRequestTriggerEvents;
    private final String[] allowedResponseMessageTypes;
    private final String[] allowedResponseTriggerEvents;
    private final Version[] hl7Versions;
    private final Map<Boolean, Map<String, Definition>> definitions;

    public Hl7v2TransactionConfiguration(String name, String description, boolean isQuery, AuditStrategy<AuditDatasetType> clientAuditStrategy, AuditStrategy<AuditDatasetType> serverAuditStrategy, Version[] hl7Versions, String sendingApplication, String sendingFacility, ErrorCode requestErrorDefaultErrorCode, ErrorCode responseErrorDefaultErrorCode, String[] allowedRequestMessageTypes, String[] allowedRequestTriggerEvents, String[] allowedResponseMessageTypes, String[] allowedResponseTriggerEvents, boolean[] auditabilityFlags, boolean[] responseContinuabilityFlags, HapiContext hapiContext) {
        super(name, description, isQuery, clientAuditStrategy, serverAuditStrategy);
        Objects.requireNonNull(hl7Versions);
        Objects.requireNonNull(sendingApplication);
        Objects.requireNonNull(sendingFacility);
        Validate.noNullElements((Object[])allowedRequestMessageTypes);
        Validate.noNullElements((Object[])allowedRequestTriggerEvents);
        Validate.noNullElements((Object[])allowedResponseMessageTypes);
        Validate.noNullElements((Object[])allowedResponseTriggerEvents);
        Objects.requireNonNull(hapiContext);
        Validate.notEmpty((Object[])allowedRequestMessageTypes);
        Validate.isTrue((allowedRequestMessageTypes.length == allowedRequestTriggerEvents.length ? 1 : 0) != 0);
        Validate.isTrue((allowedRequestMessageTypes.length == allowedResponseMessageTypes.length ? 1 : 0) != 0);
        Validate.isTrue((allowedRequestMessageTypes.length == allowedResponseTriggerEvents.length ? 1 : 0) != 0);
        if (auditabilityFlags != null) {
            Validate.isTrue((allowedRequestMessageTypes.length == auditabilityFlags.length ? 1 : 0) != 0);
        }
        if (responseContinuabilityFlags != null) {
            Validate.isTrue((allowedRequestMessageTypes.length == responseContinuabilityFlags.length ? 1 : 0) != 0);
        }
        this.hl7Versions = hl7Versions;
        this.allowedRequestMessageTypes = allowedRequestMessageTypes;
        this.allowedRequestTriggerEvents = allowedRequestTriggerEvents;
        this.allowedResponseMessageTypes = allowedResponseMessageTypes;
        this.allowedResponseTriggerEvents = allowedResponseTriggerEvents;
        this.sendingApplication = sendingApplication;
        this.sendingFacility = sendingFacility;
        this.requestErrorDefaultErrorCode = requestErrorDefaultErrorCode;
        this.responseErrorDefaultErrorCode = responseErrorDefaultErrorCode;
        this.hapiContext = hapiContext;
        this.definitions = new HashMap<Boolean, Map<String, Definition>>();
        this.definitions.put(true, Hl7v2TransactionConfiguration.createDefinitionsMap(allowedRequestMessageTypes, allowedRequestTriggerEvents, auditabilityFlags, responseContinuabilityFlags));
        this.definitions.put(false, Hl7v2TransactionConfiguration.createDefinitionsMap(allowedResponseMessageTypes, allowedResponseTriggerEvents, auditabilityFlags, responseContinuabilityFlags));
        if (!this.definitions.get(false).containsKey("ACK")) {
            this.definitions.get(false).put("ACK", new Definition("*", false, false));
        }
    }

    public Hl7v2TransactionConfiguration(String name, String description, boolean isQuery, AuditStrategy<AuditDatasetType> clientAuditStrategy, AuditStrategy<AuditDatasetType> serverAuditStrategy, Version hl7Version, String sendingApplication, String sendingFacility, ErrorCode requestErrorDefaultErrorCode, ErrorCode responseErrorDefaultErrorCode, String allowedRequestMessageType, String allowedRequestTriggerEvent, String allowedResponseMessageType, String allowedResponseTriggerEvent, boolean auditabilityFlag, boolean responseContinuabilityFlag, HapiContext hapiContext) {
        this(name, description, isQuery, clientAuditStrategy, serverAuditStrategy, new Version[]{hl7Version}, sendingApplication, sendingFacility, requestErrorDefaultErrorCode, responseErrorDefaultErrorCode, new String[]{allowedRequestMessageType}, new String[]{allowedRequestTriggerEvent}, new String[]{allowedResponseMessageType}, new String[]{allowedResponseTriggerEvent}, new boolean[]{auditabilityFlag}, new boolean[]{responseContinuabilityFlag}, hapiContext);
    }

    private static Map<String, Definition> createDefinitionsMap(String[] allowedMessageTypes, String[] allowedTriggerEvents, boolean[] auditabilityFlags, boolean[] responseContinuabilityFlags) {
        HashMap<String, Definition> result = new HashMap<String, Definition>();
        for (int i = 0; i < allowedMessageTypes.length; ++i) {
            Definition definition = new Definition(allowedTriggerEvents[i], auditabilityFlags != null && auditabilityFlags[i], responseContinuabilityFlags != null && responseContinuabilityFlags[i]);
            result.put(allowedMessageTypes[i], definition);
        }
        return result;
    }

    public boolean isAuditable(String messageType) {
        try {
            Definition definition = this.getDefinitionForMessageType(messageType, true);
            return definition.auditable;
        }
        catch (Hl7v2AcceptanceException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
    }

    public boolean isContinuable(String messageType) {
        try {
            Definition definition = this.getDefinitionForMessageType(messageType, true);
            return definition.responseContinuable;
        }
        catch (Hl7v2AcceptanceException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
    }

    public boolean isDataStartSegment(List<String> segments, int index) {
        return false;
    }

    public boolean isFooterStartSegment(List<String> segments, int index) {
        return false;
    }

    public void checkRequestAcceptance(Message message) throws Hl7v2AcceptanceException {
        this.checkMessageAcceptance(message, true);
    }

    public void checkResponseAcceptance(Message message) throws Hl7v2AcceptanceException {
        this.checkMessageAcceptance(message, false);
        try {
            if (!ArrayUtils.contains((Object[])new String[]{"AA", "AR", "AE", "CA", "CR", "CE"}, (Object)new Terser(message).get("MSA-1"))) {
                throw new Hl7v2AcceptanceException("Bad response: missing or invalid MSA segment", ErrorCode.REQUIRED_FIELD_MISSING);
            }
        }
        catch (HL7Exception e) {
            throw new Hl7v2AcceptanceException("Bad response: missing or invalid MSA segment", ErrorCode.APPLICATION_INTERNAL_ERROR);
        }
    }

    public void checkMessageAcceptance(Message message, boolean isRequest) throws Hl7v2AcceptanceException {
        try {
            Segment msh = (Segment)message.get("MSH");
            this.checkMessageAcceptance(Terser.get((Segment)msh, (int)9, (int)0, (int)1, (int)1), Terser.get((Segment)msh, (int)9, (int)0, (int)2, (int)1), Terser.get((Segment)msh, (int)9, (int)0, (int)3, (int)1), Terser.get((Segment)msh, (int)12, (int)0, (int)1, (int)1), isRequest);
        }
        catch (Hl7v2AcceptanceException e) {
            throw e;
        }
        catch (HL7Exception e) {
            throw new Hl7v2AcceptanceException("Missing or invalid MSH segment: " + e.getMessage(), ErrorCode.APPLICATION_INTERNAL_ERROR);
        }
    }

    public void checkMessageAcceptance(String messageType, String triggerEvent, String messageStructure, String version, boolean isRequest) throws Hl7v2AcceptanceException {
        this.checkMessageVersion(version);
        Definition definition = this.getDefinitionForMessageType(messageType, isRequest);
        if (!definition.isAllowedTriggerEvent(triggerEvent)) {
            throw new Hl7v2AcceptanceException("Invalid trigger event " + triggerEvent + ", must be one of " + Hl7v2TransactionConfiguration.join(definition.triggerEvents), ErrorCode.UNSUPPORTED_EVENT_CODE);
        }
        if (!StringUtils.isEmpty((CharSequence)messageStructure)) {
            boolean bothAreAcks;
            String expectedMessageStructure;
            String event = messageType + "_" + triggerEvent;
            try {
                expectedMessageStructure = this.hapiContext.getModelClassFactory().getMessageStructureForEvent(event, Version.versionOf((String)version));
            }
            catch (HL7Exception e) {
                throw new Hl7v2AcceptanceException("Acceptance check failed", ErrorCode.UNKNOWN_KEY_IDENTIFIER);
            }
            if ("QBP_ZV1".equals(event)) {
                expectedMessageStructure = "QBP_Q21";
            } else if ("RSP_ZV2".equals(event)) {
                expectedMessageStructure = "RSP_ZV2";
            }
            boolean bothAreEqual = messageStructure.equals(expectedMessageStructure);
            boolean bl = bothAreAcks = messageStructure.startsWith("ACK") && expectedMessageStructure != null && expectedMessageStructure.startsWith("ACK");
            if (!bothAreEqual && !bothAreAcks) {
                throw new Hl7v2AcceptanceException("Invalid message structure " + messageStructure + ", must be " + expectedMessageStructure, ErrorCode.APPLICATION_INTERNAL_ERROR);
            }
        }
    }

    private Definition getDefinitionForMessageType(String messageType, boolean isRequest) throws Hl7v2AcceptanceException {
        Definition definition = this.definitions.get(isRequest).get(messageType);
        if (definition == null && (definition = this.definitions.get(isRequest).get("*")) == null) {
            throw new Hl7v2AcceptanceException("Invalid message type " + messageType + ", must be one of " + Hl7v2TransactionConfiguration.join(this.definitions.get(isRequest).keySet()), ErrorCode.UNSUPPORTED_MESSAGE_TYPE);
        }
        return definition;
    }

    private void checkMessageVersion(String version) throws Hl7v2AcceptanceException {
        Version messageVersion = Version.versionOf((String)version);
        if (!ArrayUtils.contains((Object[])this.hl7Versions, (Object)messageVersion)) {
            throw new Hl7v2AcceptanceException("Invalid HL7 version " + version + ", must be one of " + this.supportedVersions(this.hl7Versions), ErrorCode.UNSUPPORTED_VERSION_ID);
        }
    }

    private String supportedVersions(Version ... hl7versions) {
        StringBuilder builder = new StringBuilder();
        for (Version v : hl7versions) {
            builder.append(v.getVersion()).append(' ');
        }
        return builder.toString();
    }

    public Parser getParser() {
        return this.getHapiContext().getPipeParser();
    }

    private static String join(Collection<String> collection) {
        return StringUtils.join(collection, (char)' ');
    }

    public <M extends Message> M request(String messageType, String trigger) {
        Message message = MessageUtils.makeMessage((HapiContext)this.getHapiContext(), (String)messageType, (String)trigger, (String)this.getHl7Versions()[0].getVersion());
        try {
            this.checkRequestAcceptance(message);
            return (M)message;
        }
        catch (Hl7v2AcceptanceException e) {
            throw new HL7v2Exception((HL7Exception)e);
        }
    }

    public <M extends Message> M request(String trigger) {
        return this.request(this.allowedRequestMessageTypes[0], trigger);
    }

    public <M extends Message> M request() {
        return this.request(this.allowedRequestMessageTypes[0], this.allowedRequestTriggerEvents[0]);
    }

    @Generated
    public String getSendingApplication() {
        return this.sendingApplication;
    }

    @Generated
    public String getSendingFacility() {
        return this.sendingFacility;
    }

    @Generated
    public ErrorCode getRequestErrorDefaultErrorCode() {
        return this.requestErrorDefaultErrorCode;
    }

    @Generated
    public ErrorCode getResponseErrorDefaultErrorCode() {
        return this.responseErrorDefaultErrorCode;
    }

    @Generated
    public HapiContext getHapiContext() {
        return this.hapiContext;
    }

    @Generated
    public String[] getAllowedRequestMessageTypes() {
        return this.allowedRequestMessageTypes;
    }

    @Generated
    public String[] getAllowedRequestTriggerEvents() {
        return this.allowedRequestTriggerEvents;
    }

    @Generated
    public String[] getAllowedResponseMessageTypes() {
        return this.allowedResponseMessageTypes;
    }

    @Generated
    public String[] getAllowedResponseTriggerEvents() {
        return this.allowedResponseTriggerEvents;
    }

    @Generated
    public Version[] getHl7Versions() {
        return this.hl7Versions;
    }

    private static class Definition {
        private final Set<String> triggerEvents;
        private final boolean auditable;
        private final boolean responseContinuable;

        Definition(String triggerEventsString, boolean auditable, boolean responseContinuable) {
            this.triggerEvents = new HashSet<String>(Arrays.asList(StringUtils.split((String)triggerEventsString, (char)' ')));
            this.auditable = auditable;
            this.responseContinuable = responseContinuable;
        }

        boolean isAllowedTriggerEvent(String triggerEvent) {
            return this.triggerEvents.contains("*") || this.triggerEvents.contains(triggerEvent);
        }
    }
}

