/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2.storage;

import ca.uhn.hl7v2.model.Message;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.openehealth.ipf.commons.ihe.hl7v2.storage.InteractiveContinuationStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcacheInteractiveContinuationStorage
implements InteractiveContinuationStorage {
    private static final transient Logger LOG = LoggerFactory.getLogger(EhcacheInteractiveContinuationStorage.class);
    private final Ehcache ehcache;

    public EhcacheInteractiveContinuationStorage(Ehcache ehcache) {
        Objects.requireNonNull(ehcache);
        this.ehcache = ehcache;
    }

    @Override
    public void put(String continuationPointer, String chainId, Message fragment) {
        InteractiveContinuationChain chain;
        Element element = this.ehcache.get((Serializable)((Object)chainId));
        if (element != null) {
            chain = (InteractiveContinuationChain)element.getObjectValue();
        } else {
            LOG.debug("Create chain for storage key {}", (Object)chainId);
            chain = new InteractiveContinuationChain();
            this.ehcache.put(new Element((Serializable)((Object)chainId), (Serializable)chain));
        }
        chain.put(continuationPointer, fragment);
    }

    @Override
    public Message get(String continuationPointer, String chainId) {
        Element element = this.ehcache.get((Serializable)((Object)chainId));
        if (element != null) {
            InteractiveContinuationChain chain = (InteractiveContinuationChain)element.getObjectValue();
            return chain.get(continuationPointer);
        }
        return null;
    }

    @Override
    public boolean delete(String chainId) {
        return this.ehcache.remove((Serializable)((Object)chainId));
    }

    private static class InteractiveContinuationChain
    implements Serializable {
        private final Map<String, Message> responseMessages = Collections.synchronizedMap(new HashMap());

        private InteractiveContinuationChain() {
        }

        public void put(String continuationPointer, Message message) {
            this.responseMessages.put(continuationPointer, message);
        }

        public Message get(String continuationPointer) {
            return this.responseMessages.get(continuationPointer);
        }
    }
}

