/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2.definitions.pix.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.CX;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import org.openehealth.ipf.modules.hl7.HL7v2Exception;

public class QPD
extends AbstractSegment {
    public QPD(Group parentGroup, ModelClassFactory modelFactory) {
        super(parentGroup, modelFactory);
        Message msg = this.getMessage();
        try {
            this.add(CE.class, true, 1, 250, new Object[]{msg}, "Message Query Name");
            this.add(ST.class, true, 1, 32, new Object[]{msg}, "Query Tag");
            this.add(CX.class, true, 1, 256, new Object[]{msg}, "Person Identifier");
            this.add(CX.class, false, 0, 256, new Object[]{msg}, "What domains returned");
        }
        catch (HL7Exception e) {
            throw new HL7v2Exception(e);
        }
    }

    public CE getMessageQueryName() {
        return (CE)this.getTypedField(1, 0);
    }

    public CE getQpd1_MessageQueryName() {
        return (CE)this.getTypedField(1, 0);
    }

    public ST getQueryTag() {
        return (ST)this.getTypedField(2, 0);
    }

    public ST getQpd2_QueryTag() {
        return (ST)this.getTypedField(2, 0);
    }

    public CX getPersonIdentifier() {
        return (CX)this.getTypedField(3, 0);
    }

    public CX getQpd3_PersonIdentifier() {
        return (CX)this.getTypedField(3, 0);
    }

    public CX getWhatDomainsReturned(int rep) {
        return (CX)this.getTypedField(4, rep);
    }

    public CX getQpd4_WhatDomainsReturned(int rep) {
        return (CX)this.getTypedField(4, rep);
    }

    public CX[] getWhatDomainsReturned() {
        return (CX[])this.getTypedField(4, (Type[])new CX[0]);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new CX(this.getMessage());
            }
            case 3: {
                return new CX(this.getMessage());
            }
        }
        return null;
    }
}

