/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2.definitions.pix.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.segment.EVN;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import java.util.Map;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.pix.v231.group.ADT_A39_PATIENT;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.pix.v231.segment.ZZI;
import org.openehealth.ipf.modules.hl7.model.AbstractMessage;

public class ADT_A39
extends AbstractMessage {
    public ADT_A39() {
    }

    public ADT_A39(ModelClassFactory factory) {
        super(factory);
    }

    protected Map<Class<? extends Structure>, AbstractMessage.Cardinality> structures(Map<Class<? extends Structure>, AbstractMessage.Cardinality> s) {
        s.put(MSH.class, AbstractMessage.Cardinality.REQUIRED);
        s.put(EVN.class, AbstractMessage.Cardinality.REQUIRED);
        s.put(ADT_A39_PATIENT.class, AbstractMessage.Cardinality.REQUIRED_REPEATING);
        s.put(ZZI.class, AbstractMessage.Cardinality.OPTIONAL);
        return s;
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public EVN getEVN() {
        return (EVN)this.getTyped("EVN", EVN.class);
    }

    public ADT_A39_PATIENT getPATIENT() {
        return (ADT_A39_PATIENT)this.getTyped("PATIENT", ADT_A39_PATIENT.class);
    }

    public ADT_A39_PATIENT getPATIENT(int rep) {
        return (ADT_A39_PATIENT)this.getTyped("PATIENT", rep, ADT_A39_PATIENT.class);
    }

    public int getPATIENTReps() {
        return this.getReps("PATIENT");
    }

    public List<ADT_A39_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", ADT_A39_PATIENT.class);
    }

    public void insertPATIENT(ADT_A39_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", (Structure)structure, rep);
    }

    public ADT_A39_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (ADT_A39_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public ADT_A39_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (ADT_A39_PATIENT)super.removeRepetition("PATIENT", rep);
    }
}

