/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2.definitions.pix.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.segment.ACC;
import ca.uhn.hl7v2.model.v231.segment.AL1;
import ca.uhn.hl7v2.model.v231.segment.DB1;
import ca.uhn.hl7v2.model.v231.segment.DG1;
import ca.uhn.hl7v2.model.v231.segment.DRG;
import ca.uhn.hl7v2.model.v231.segment.EVN;
import ca.uhn.hl7v2.model.v231.segment.GT1;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.NK1;
import ca.uhn.hl7v2.model.v231.segment.OBX;
import ca.uhn.hl7v2.model.v231.segment.PD1;
import ca.uhn.hl7v2.model.v231.segment.PID;
import ca.uhn.hl7v2.model.v231.segment.PV1;
import ca.uhn.hl7v2.model.v231.segment.PV2;
import ca.uhn.hl7v2.model.v231.segment.UB1;
import ca.uhn.hl7v2.model.v231.segment.UB2;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import java.util.Map;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.pix.v231.group.ADT_A01_INSURANCE;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.pix.v231.group.ADT_A01_PROCEDURE;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.pix.v231.segment.ZZI;
import org.openehealth.ipf.modules.hl7.model.AbstractMessage;

public class ADT_A01
extends AbstractMessage {
    public ADT_A01() {
    }

    public ADT_A01(ModelClassFactory factory) {
        super(factory);
    }

    protected Map<Class<? extends Structure>, AbstractMessage.Cardinality> structures(Map<Class<? extends Structure>, AbstractMessage.Cardinality> s) {
        s.put(MSH.class, AbstractMessage.Cardinality.REQUIRED);
        s.put(EVN.class, AbstractMessage.Cardinality.REQUIRED);
        s.put(PID.class, AbstractMessage.Cardinality.REQUIRED);
        s.put(PD1.class, AbstractMessage.Cardinality.OPTIONAL);
        s.put(PD1.class, AbstractMessage.Cardinality.OPTIONAL);
        s.put(NK1.class, AbstractMessage.Cardinality.OPTIONAL_REPEATING);
        s.put(PV1.class, AbstractMessage.Cardinality.REQUIRED);
        s.put(PV2.class, AbstractMessage.Cardinality.OPTIONAL);
        s.put(DB1.class, AbstractMessage.Cardinality.OPTIONAL_REPEATING);
        s.put(OBX.class, AbstractMessage.Cardinality.OPTIONAL_REPEATING);
        s.put(AL1.class, AbstractMessage.Cardinality.OPTIONAL_REPEATING);
        s.put(DG1.class, AbstractMessage.Cardinality.OPTIONAL_REPEATING);
        s.put(DRG.class, AbstractMessage.Cardinality.OPTIONAL);
        s.put(ADT_A01_PROCEDURE.class, AbstractMessage.Cardinality.OPTIONAL_REPEATING);
        s.put(GT1.class, AbstractMessage.Cardinality.OPTIONAL_REPEATING);
        s.put(ADT_A01_INSURANCE.class, AbstractMessage.Cardinality.OPTIONAL);
        s.put(ACC.class, AbstractMessage.Cardinality.OPTIONAL);
        s.put(UB1.class, AbstractMessage.Cardinality.OPTIONAL);
        s.put(UB2.class, AbstractMessage.Cardinality.OPTIONAL);
        s.put(ZZI.class, AbstractMessage.Cardinality.OPTIONAL);
        return s;
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        return this.getTyped(MSH.class);
    }

    public EVN getEVN() {
        return this.getTyped(EVN.class);
    }

    public PID getPID() {
        return this.getTyped(PID.class);
    }

    public PD1 getPD1() {
        return this.getTyped(PD1.class);
    }

    public NK1 getNK1() {
        return this.getTyped(NK1.class);
    }

    public NK1 getNK1(int rep) {
        return this.getTyped(rep, NK1.class);
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList(NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        this.insertRepetition("NK1", (Structure)structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)this.insertRep("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)this.removeRep("NK1", rep);
    }

    public PV1 getPV1() {
        return this.getTyped(PV1.class);
    }

    public PV2 getPV2() {
        return this.getTyped(PV2.class);
    }

    public DB1 getDB1() {
        return this.getTyped(DB1.class);
    }

    public DB1 getDB1(int rep) {
        return this.getTyped(rep, DB1.class);
    }

    public int getDB1Reps() {
        return this.getReps("DB1");
    }

    public List<DB1> getDB1All() throws HL7Exception {
        return this.getAllAsList(DB1.class);
    }

    public void insertDB1(DB1 structure, int rep) throws HL7Exception {
        this.insertRepetition("DB1", (Structure)structure, rep);
    }

    public DB1 insertDB1(int rep) throws HL7Exception {
        return (DB1)this.insertRep("DB1", rep);
    }

    public DB1 removeDB1(int rep) throws HL7Exception {
        return (DB1)this.removeRep("DB1", rep);
    }

    public OBX getOBX() {
        return this.getTyped(OBX.class);
    }

    public OBX getOBX(int rep) {
        return this.getTyped(rep, OBX.class);
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList(OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        this.insertRepetition("OBX", (Structure)structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)this.insertRep("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)this.removeRep("OBX", rep);
    }

    public AL1 getAL1() {
        return this.getTyped(AL1.class);
    }

    public AL1 getAL1(int rep) {
        return this.getTyped(rep, AL1.class);
    }

    public int getAL1Reps() {
        return this.getReps("AL1");
    }

    public List<AL1> getAL1All() throws HL7Exception {
        return this.getAllAsList(AL1.class);
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        this.insertRepetition("AL1", (Structure)structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)this.insertRep("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)this.removeRep("AL1", rep);
    }

    public DG1 getDG1() {
        return this.getTyped(DG1.class);
    }

    public DG1 getDG1(int rep) {
        return this.getTyped(rep, DG1.class);
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList(DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        this.insertRepetition("DG1", (Structure)structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)this.insertRep("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)this.removeRep("DG1", rep);
    }

    public DRG getDRG() {
        return this.getTyped(DRG.class);
    }

    public ADT_A01_PROCEDURE getPROCEDURE() {
        return (ADT_A01_PROCEDURE)this.getTyped("PROCEDURE", ADT_A01_PROCEDURE.class);
    }

    public ADT_A01_PROCEDURE getPROCEDURE(int rep) {
        return (ADT_A01_PROCEDURE)this.getTyped("PROCEDURE", rep, ADT_A01_PROCEDURE.class);
    }

    public int getPROCEDUREReps() {
        return this.getReps("PROCEDURE");
    }

    public List<ADT_A01_PROCEDURE> getPROCEDUREAll() throws HL7Exception {
        return this.getAllAsList("PROCEDURE", ADT_A01_PROCEDURE.class);
    }

    public void insertPROCEDURE(ADT_A01_PROCEDURE structure, int rep) throws HL7Exception {
        this.insertRepetition("PROCEDURE", (Structure)structure, rep);
    }

    public ADT_A01_PROCEDURE insertPROCEDURE(int rep) throws HL7Exception {
        return (ADT_A01_PROCEDURE)((Object)this.insertRep("PROCEDURE", rep));
    }

    public ADT_A01_PROCEDURE removePROCEDURE(int rep) throws HL7Exception {
        return (ADT_A01_PROCEDURE)((Object)this.removeRep("PROCEDURE", rep));
    }

    public GT1 getGT1() {
        return this.getTyped(GT1.class);
    }

    public GT1 getGT1(int rep) {
        return this.getTyped(rep, GT1.class);
    }

    public int getGT1Reps() {
        return this.getReps("GT1");
    }

    public List<GT1> getGT1All() throws HL7Exception {
        return this.getAllAsList(GT1.class);
    }

    public void insertGT1(GT1 structure, int rep) throws HL7Exception {
        this.insertRepetition("GT1", (Structure)structure, rep);
    }

    public GT1 insertGT1(int rep) throws HL7Exception {
        return (GT1)this.insertRep("GT1", rep);
    }

    public GT1 removeGT1(int rep) throws HL7Exception {
        return (GT1)this.removeRep("GT1", rep);
    }

    public ADT_A01_INSURANCE getINSURANCE() {
        return (ADT_A01_INSURANCE)this.getTyped("INSURANCE", ADT_A01_INSURANCE.class);
    }

    public ADT_A01_INSURANCE getINSURANCE(int rep) {
        return (ADT_A01_INSURANCE)this.getTyped("INSURANCE", rep, ADT_A01_INSURANCE.class);
    }

    public int getIN1IN2IN3Reps() {
        return this.getReps("INSURANCE");
    }

    public List<ADT_A01_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", ADT_A01_INSURANCE.class);
    }

    public void insertINSURANCE(ADT_A01_INSURANCE structure, int rep) throws HL7Exception {
        this.insertRepetition("INSURANCE", (Structure)structure, rep);
    }

    public ADT_A01_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (ADT_A01_INSURANCE)((Object)this.insertRep("INSURANCE", rep));
    }

    public ADT_A01_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (ADT_A01_INSURANCE)((Object)this.removeRep("INSURANCE", rep));
    }

    public ACC getACC() {
        return this.getTyped(ACC.class);
    }

    public UB1 getUB1() {
        return this.getTyped(UB1.class);
    }

    public UB2 getUB2() {
        return this.getTyped(UB2.class);
    }

    private <T extends Structure> T insertRep(String name, int rep) throws HL7Exception {
        return (T)this.insertRepetition(name, rep);
    }

    private <T extends Structure> T removeRep(String name, int rep) throws HL7Exception {
        return (T)this.removeRepetition(name, rep);
    }

    private <T extends Structure> T getTyped(Class<T> clazz) {
        return (T)this.getTyped(clazz.getSimpleName(), clazz);
    }

    private <T extends Structure> T getTyped(int rep, Class<T> clazz) {
        return (T)this.getTyped(clazz.getSimpleName(), rep, clazz);
    }

    private <T extends Structure> List<T> getAllAsList(Class<T> clazz) throws HL7Exception {
        return this.getAllAsList(clazz.getSimpleName(), clazz);
    }
}

