/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2.definitions.pdq.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.CX;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.datatype.QIP;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import org.openehealth.ipf.modules.hl7.HL7v2Exception;

public class QPD
extends AbstractSegment {
    public QPD(Group parentGroup, ModelClassFactory modelFactory) {
        super(parentGroup, modelFactory);
        Message msg = this.getMessage();
        try {
            this.add(CE.class, true, 1, 250, new Object[]{msg}, "Message Query Name");
            this.add(ST.class, true, 1, 32, new Object[]{msg}, "Query Tag");
            this.add(QIP.class, true, 0, 256, new Object[]{msg}, "Demographics Fields");
            this.add(NM.class, false, 1, 16, new Object[]{msg}, "Search Confidence Threshold");
            this.add(ST.class, false, 1, 199, new Object[]{msg}, "Algorithm Name");
            this.add(ST.class, false, 1, 199, new Object[]{msg}, "Algorithm Version");
            this.add(ST.class, false, 1, 199, new Object[]{msg}, "Algorithm Description");
            this.add(CX.class, false, 0, 256, new Object[]{msg}, "What domains returned");
        }
        catch (HL7Exception e) {
            throw new HL7v2Exception(e);
        }
    }

    public CE getMessageQueryName() {
        return (CE)this.getTypedField(1, 0);
    }

    public CE getQpd1_MessageQueryName() {
        return (CE)this.getTypedField(1, 0);
    }

    public ST getQueryTag() {
        return (ST)this.getTypedField(2, 0);
    }

    public ST getQpd2_QueryTag() {
        return (ST)this.getTypedField(2, 0);
    }

    public QIP getDemographicsFields(int rep) {
        return (QIP)this.getTypedField(3, rep);
    }

    public QIP getQpd3_DemographicsFields(int rep) {
        return (QIP)this.getTypedField(3, rep);
    }

    public QIP[] getDemographicsFields() {
        return (QIP[])this.getTypedField(3, (Type[])new QIP[0]);
    }

    public QIP[] getQpd3_DemographicsFields() {
        return (QIP[])this.getTypedField(3, (Type[])new QIP[0]);
    }

    public int getDemographicsFieldsReps() {
        return this.getReps(3);
    }

    public int getQpd3_DemographicsFieldsReps() {
        return this.getReps(3);
    }

    public QIP insertDemographicsFieldsReps(int rep) throws HL7Exception {
        return (QIP)super.insertRepetition(3, rep);
    }

    public QIP insertQpd3_DemographicsFieldsReps(int rep) throws HL7Exception {
        return (QIP)super.insertRepetition(3, rep);
    }

    public QIP removeDemographicsFieldsReps(int rep) throws HL7Exception {
        return (QIP)super.removeRepetition(3, rep);
    }

    public QIP removeQpd3_DemographicsFieldsReps(int rep) throws HL7Exception {
        return (QIP)super.removeRepetition(3, rep);
    }

    public NM getSearchConfidenceThreshold() {
        return (NM)this.getTypedField(4, 0);
    }

    public NM getQpd4_SearchConfidenceThreshold() {
        return (NM)this.getTypedField(4, 0);
    }

    public ST getAlgorithmName() {
        return (ST)this.getTypedField(5, 0);
    }

    public ST getQpd5_AlgorithmName() {
        return (ST)this.getTypedField(5, 0);
    }

    public ST getAlgorithmVersion() {
        return (ST)this.getTypedField(6, 0);
    }

    public ST getQpd6_AlgorithmVersion() {
        return (ST)this.getTypedField(6, 0);
    }

    public ST AlgorithmDescription() {
        return (ST)this.getTypedField(7, 0);
    }

    public ST getQpd7_AlgorithmDescription() {
        return (ST)this.getTypedField(7, 0);
    }

    public CX getWhatDomainsReturned(int rep) {
        return (CX)this.getTypedField(8, rep);
    }

    public CX getQpd8_WhatDomainsReturned(int rep) {
        return (CX)this.getTypedField(8, rep);
    }

    public CX[] getWhatDomainsReturned() {
        return (CX[])this.getTypedField(8, (Type[])new CX[0]);
    }

    public CX[] getQpd8_WhatDomainsReturned() {
        return (CX[])this.getTypedField(8, (Type[])new CX[0]);
    }

    public int getWhatDomainsReturnedReps() {
        return this.getReps(8);
    }

    public int getQpd8_WhatDomainsReturnedReps() {
        return this.getReps(8);
    }

    public CX insertWhatDomainsReturnedReps(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(8, rep);
    }

    public CX insertQpd8_WhatDomainsReturnedReps(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(8, rep);
    }

    public CX removeWhatDomainsReturnedReps(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(8, rep);
    }

    public CX removeQpd8_WhatDomainsReturnedReps(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(8, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new QIP(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new ST(this.getMessage());
            }
            case 7: {
                return new CX(this.getMessage());
            }
        }
        return null;
    }
}

