/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2.definitions.pam.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CWE;
import ca.uhn.hl7v2.model.v25.datatype.EI;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.model.v25.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import org.openehealth.ipf.modules.hl7.HL7v2Exception;

public class ZBE
extends AbstractSegment {
    public ZBE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        Message message = this.getMessage();
        try {
            this.add(EI.class, true, 0, 427, new Object[]{message}, "Movement ID");
            this.add(TS.class, true, 1, 26, new Object[]{message}, "Start Movement Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{message}, "End Movement Date/Time");
            this.add(ST.class, true, 1, 6, new Object[]{message}, "Movement Action");
            this.add(ID.class, true, 1, 1, new Object[]{message}, "Historical Movement Indicator");
            this.add(ID.class, false, 1, 3, new Object[]{message}, "Original trigger event code");
            this.add(XON.class, false, 1, 567, new Object[]{message}, "Responsible Ward");
            this.add(XON.class, false, 1, 567, new Object[]{message}, "Responsible Nursing Ward");
            this.add(CWE.class, false, 1, 3, new Object[]{message}, "Movement Scope");
        }
        catch (HL7Exception he) {
            throw new HL7v2Exception(he);
        }
    }

    public EI getMovementID(int rep) {
        return (EI)this.getTypedField(1, rep);
    }

    public EI[] getMovementID() {
        return (EI[])this.getTypedField(1, (Type[])new EI[0]);
    }

    public TS getStartMovementDateTime() {
        return (TS)this.getTypedField(2, 0);
    }

    public TS getStartMovementEndTime() {
        return (TS)this.getTypedField(3, 0);
    }

    public ST getMovementAction() {
        return (ST)this.getTypedField(4, 0);
    }

    public ID getHistoricalMovementIndicator() {
        return (ID)this.getTypedField(5, 0);
    }

    public ID getOriginalTriggerEventCode() {
        return (ID)this.getTypedField(6, 0);
    }

    public XON getResponsibleWard() {
        return (XON)this.getTypedField(7, 0);
    }

    public XON getResponsibleNursingWard() {
        return (XON)this.getTypedField(8, 0);
    }

    public CWE getMovementScope() {
        return (CWE)this.getTypedField(9, 0);
    }
}

