/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2.definitions;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.conf.store.ProfileStore;
import ca.uhn.hl7v2.conf.store.ProfileStoreFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.Escaping;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.util.idgenerator.FileBasedHiLoGenerator;
import ca.uhn.hl7v2.util.idgenerator.IDGenerator;
import ca.uhn.hl7v2.validation.ValidationExceptionHandlerFactory;
import ca.uhn.hl7v2.validation.builder.ValidationRuleBuilder;
import ca.uhn.hl7v2.validation.builder.support.DefaultValidationWithoutTNBuilder;
import ca.uhn.hl7v2.validation.impl.SimpleValidationExceptionHandler;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.ConformanceProfileBasedValidationBuilder;
import org.openehealth.ipf.gazelle.validation.profile.HL7v2Transactions;
import org.openehealth.ipf.gazelle.validation.profile.store.GazelleProfileStore;
import org.openehealth.ipf.modules.hl7.parser.DefaultEscaping;

public class HapiContextFactory {
    private static IDGenerator idGenerator = new FileBasedHiLoGenerator();

    public static synchronized void setIdGenerator(IDGenerator generator) {
        idGenerator = generator;
    }

    public static HapiContext createHapiContext() {
        DefaultHapiContext context = new DefaultHapiContext();
        context.getParserConfiguration().setEscaping((Escaping)DefaultEscaping.INSTANCE);
        return context;
    }

    public static HapiContext createHapiContext(ModelClassFactory modelClassFactory) {
        return HapiContextFactory.createHapiContext(modelClassFactory, (ValidationRuleBuilder)new DefaultValidationWithoutTNBuilder(), ProfileStoreFactory.getProfileStore());
    }

    public static HapiContext createHapiContext(HL7v2Transactions transactions) {
        return HapiContextFactory.createHapiContext((ModelClassFactory)new DefaultModelClassFactory(), transactions);
    }

    public static HapiContext createHapiContext(ModelClassFactory modelClassFactory, HL7v2Transactions transactions) {
        return HapiContextFactory.createHapiContext(modelClassFactory, (ValidationRuleBuilder)new ConformanceProfileBasedValidationBuilder(transactions), (ProfileStore)new GazelleProfileStore());
    }

    public static HapiContext createHapiContext(ModelClassFactory modelClassFactory, ValidationRuleBuilder validationRuleBuilder, ProfileStore profileStore) {
        DefaultHapiContext context = new DefaultHapiContext(modelClassFactory);
        context.setProfileStore(profileStore);
        context.setValidationRuleBuilder(validationRuleBuilder);
        context.getParserConfiguration().setValidating(false);
        context.getParserConfiguration().setIdGenerator(idGenerator);
        context.getParserConfiguration().setEscaping((Escaping)DefaultEscaping.INSTANCE);
        context.setValidationExceptionHandlerFactory((ValidationExceptionHandlerFactory)new SimpleValidationExceptionHandler((HapiContext)context));
        return context;
    }
}

