/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2.audit.pdqcore;

import ca.uhn.hl7v2.model.Message;
import java.util.Map;
import java.util.Objects;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.ParticipantObjectIdType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;
import org.openehealth.ipf.commons.ihe.core.atna.AuditDataset;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategySupport;
import org.openehealth.ipf.commons.ihe.core.atna.event.QueryInformationBuilder;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.QueryAuditDataset;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.codes.MllpEventTypeCode;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.pdqcore.PdqAuditStrategyUtils;

public abstract class PdqAuditStrategy
extends AuditStrategySupport<QueryAuditDataset> {
    private final MllpEventTypeCode eventTypeCode;
    private final ParticipantObjectIdType participantObjectIdType;

    public PdqAuditStrategy(boolean serverSide, MllpEventTypeCode eventTypeCode, ParticipantObjectIdType participantObjectIdType) {
        super(serverSide);
        this.eventTypeCode = Objects.requireNonNull(eventTypeCode, "eventTypeCode must be not null");
        this.participantObjectIdType = Objects.requireNonNull(participantObjectIdType, "participantObjectIdType must be not null");
    }

    public QueryAuditDataset enrichAuditDatasetFromRequest(QueryAuditDataset auditDataset, Object msg, Map<String, Object> parameters) {
        PdqAuditStrategyUtils.enrichAuditDatasetFromRequest(auditDataset, (Message)msg, parameters);
        return auditDataset;
    }

    public boolean enrichAuditDatasetFromResponse(QueryAuditDataset auditDataset, Object msg, AuditContext auditContext) {
        PdqAuditStrategyUtils.enrichAuditDatasetFromResponse(auditDataset, (Message)msg, auditContext);
        return true;
    }

    public QueryAuditDataset createAuditDataset() {
        return new QueryAuditDataset(this.isServerSide());
    }

    public AuditMessage[] makeAuditMessage(AuditContext auditContext, QueryAuditDataset auditDataset) {
        return new QueryInformationBuilder(auditContext, (AuditDataset)auditDataset, (EventType)this.eventTypeCode, new PurposeOfUse[0]).setQueryParameters(auditDataset.getMessageControlId(), this.participantObjectIdType, auditDataset.getPayload(), "MSH-10", auditDataset.getMessageControlId()).addPatients(auditDataset.getPatientIds()).getMessages();
    }
}

