/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2.audit.iti8;

import ca.uhn.hl7v2.model.Message;
import java.util.Map;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;
import org.openehealth.ipf.commons.ihe.core.atna.AuditDataset;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategySupport;
import org.openehealth.ipf.commons.ihe.core.atna.event.PatientRecordEventBuilder;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.FeedAuditDataset;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.codes.MllpEventTypeCode;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.iti8.Iti8AuditStrategyUtils;

public class Iti8AuditStrategy
extends AuditStrategySupport<FeedAuditDataset> {
    public Iti8AuditStrategy(boolean serverSide) {
        super(serverSide);
    }

    public FeedAuditDataset enrichAuditDatasetFromRequest(FeedAuditDataset auditDataset, Object msg, Map<String, Object> parameters) {
        Iti8AuditStrategyUtils.enrichAuditDatasetFromRequest(auditDataset, (Message)msg);
        return auditDataset;
    }

    public FeedAuditDataset createAuditDataset() {
        return new FeedAuditDataset(this.isServerSide());
    }

    public AuditMessage[] makeAuditMessage(AuditContext auditContext, FeedAuditDataset auditDataset) {
        switch (auditDataset.getMessageType()) {
            case "A01": 
            case "A04": 
            case "A05": {
                return new AuditMessage[]{this.patientRecordAuditMessage(auditContext, auditDataset, EventActionCode.Create, true)};
            }
            case "A08": {
                return new AuditMessage[]{this.patientRecordAuditMessage(auditContext, auditDataset, EventActionCode.Update, true)};
            }
            case "A40": {
                return new AuditMessage[]{this.patientRecordAuditMessage(auditContext, auditDataset, EventActionCode.Delete, false), this.patientRecordAuditMessage(auditContext, auditDataset, EventActionCode.Update, true)};
            }
        }
        throw new AuditException("Cannot create audit message for event " + auditDataset.getMessageType());
    }

    protected AuditMessage patientRecordAuditMessage(AuditContext auditContext, FeedAuditDataset auditDataset, EventActionCode eventActionCode, boolean newPatientId) {
        return new PatientRecordEventBuilder(auditContext, (AuditDataset)auditDataset, eventActionCode, (EventType)MllpEventTypeCode.PatientIdentityFeed, new PurposeOfUse[0]).addPatients("MSH-10", auditDataset.getMessageControlId(), new String[]{newPatientId ? auditDataset.getPatientId() : auditDataset.getOldPatientId()}).getMessage();
    }
}

