/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2.audit.iti64;

import java.util.Arrays;
import java.util.Collections;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectDataLifeCycle;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectIdTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCodeRole;
import org.openehealth.ipf.commons.audit.event.BaseAuditMessageBuilder;
import org.openehealth.ipf.commons.audit.event.PatientRecordBuilder;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.ParticipantObjectIdType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;
import org.openehealth.ipf.commons.ihe.core.atna.AuditDataset;
import org.openehealth.ipf.commons.ihe.core.atna.event.IHEAuditMessageBuilder;
import org.openehealth.ipf.commons.ihe.core.atna.event.PatientRecordEventBuilder;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.codes.MllpEventTypeCode;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.iti64.Iti64AuditDataset;

class IHEPatientRecordChangeLinkBuilder<T extends PatientRecordEventBuilder<T>>
extends IHEAuditMessageBuilder<T, PatientRecordBuilder> {
    private static final String URN_IHE_ITI_XPID_2017_PATIENT_IDENTIFIER_TYPE = "urn:ihe:iti:xpid:2017:patientIdentifierType";

    IHEPatientRecordChangeLinkBuilder(AuditContext auditContext, AuditDataset auditDataset) {
        super(auditContext, (BaseAuditMessageBuilder)new PatientRecordBuilder(auditDataset.getEventOutcomeIndicator(), EventActionCode.Update, (EventType)MllpEventTypeCode.XadPidLinkChange, new PurposeOfUse[0]));
        if (auditDataset.isServerSide()) {
            this.setRemoteParticipant(auditDataset);
            this.addHumanRequestor(auditDataset);
            this.setLocalParticipant(auditDataset);
        } else {
            this.setLocalParticipant(auditDataset);
            this.addHumanRequestor(auditDataset);
            this.setRemoteParticipant(auditDataset);
        }
    }

    public IHEPatientRecordChangeLinkBuilder setLocalPatientId(Iti64AuditDataset auditDataset) {
        ((PatientRecordBuilder)this.delegate).addPatient(auditDataset.getLocalPatientId(), null, Arrays.asList(this.getTypeValuePair("MSH-10", auditDataset.getMessageControlId()), this.getTypeValuePair(URN_IHE_ITI_XPID_2017_PATIENT_IDENTIFIER_TYPE, "localPatientId")), auditDataset.getSubsumedLocalPatientId() == null ? null : ParticipantObjectDataLifeCycle.Origination);
        return this;
    }

    public IHEPatientRecordChangeLinkBuilder setSubsumedLocalPatientId(Iti64AuditDataset auditDataset) {
        ((PatientRecordBuilder)this.delegate).addPatient(auditDataset.getSubsumedLocalPatientId(), null, Arrays.asList(this.getTypeValuePair("MSH-10", auditDataset.getMessageControlId()), this.getTypeValuePair(URN_IHE_ITI_XPID_2017_PATIENT_IDENTIFIER_TYPE, "subsumedPatientId")), ParticipantObjectDataLifeCycle.LogicalDeletion);
        return this;
    }

    public IHEPatientRecordChangeLinkBuilder setNewPatientId(Iti64AuditDataset auditDataset) {
        ((PatientRecordBuilder)this.delegate).addPatient(auditDataset.getNewPatientId(), null, Arrays.asList(this.getTypeValuePair("MSH-10", auditDataset.getMessageControlId()), this.getTypeValuePair(URN_IHE_ITI_XPID_2017_PATIENT_IDENTIFIER_TYPE, "newPatientId")), auditDataset.getNewPatientId().equals(auditDataset.getPreviousPatientId()) ? null : ParticipantObjectDataLifeCycle.Origination);
        return this;
    }

    public IHEPatientRecordChangeLinkBuilder setPreviousPatientId(Iti64AuditDataset auditDataset) {
        ((PatientRecordBuilder)this.delegate).addPatient(auditDataset.getPreviousPatientId(), null, Arrays.asList(this.getTypeValuePair("MSH-10", auditDataset.getMessageControlId()), this.getTypeValuePair(URN_IHE_ITI_XPID_2017_PATIENT_IDENTIFIER_TYPE, "previousPatientId")), auditDataset.getNewPatientId().equals(auditDataset.getPreviousPatientId()) ? null : ParticipantObjectDataLifeCycle.LogicalDeletion);
        return this;
    }

    public IHEPatientRecordChangeLinkBuilder setSubmissionSet(Iti64AuditDataset auditDataset) {
        if (auditDataset.getSubmissionSetUuid() != null) {
            ((PatientRecordBuilder)this.delegate).addParticipantObjectIdentification((ParticipantObjectIdType)ParticipantObjectIdTypeCode.XdsMetadata, null, null, Collections.emptyList(), auditDataset.getSubmissionSetUuid(), ParticipantObjectTypeCode.System, ParticipantObjectTypeCodeRole.Job, null, null);
        }
        return this;
    }

    public void validate() {
        super.validate();
    }
}

