/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2.audit;

import java.util.Collections;
import java.util.List;
import org.openehealth.ipf.commons.audit.utils.AuditUtils;
import org.openehealth.ipf.commons.ihe.core.atna.AuditDataset;

public abstract class MllpAuditDataset
extends AuditDataset {
    private static final long serialVersionUID = -4427222097816361541L;
    private String sendingApplication;
    private String sendingFacility;
    private String receivingApplication;
    private String receivingFacility;
    private String messageType;
    private String messageControlId;
    private String localAddress;
    private String remoteAddress;

    public MllpAuditDataset(boolean serverSide) {
        super(serverSide);
    }

    public String getSourceUserId() {
        return String.format("%s|%s", this.sendingFacility, this.sendingApplication);
    }

    public String getDestinationUserId() {
        return String.format("%s|%s", this.receivingFacility, this.receivingApplication);
    }

    public String getLocalAddress() {
        return this.localAddress != null ? this.localAddress : AuditUtils.getLocalIPAddress();
    }

    public List<AuditDataset.HumanUser> getHumanUsers() {
        return Collections.emptyList();
    }

    public String getSendingApplication() {
        return this.sendingApplication;
    }

    public void setSendingApplication(String sendingApplication) {
        this.sendingApplication = sendingApplication;
    }

    public String getSendingFacility() {
        return this.sendingFacility;
    }

    public void setSendingFacility(String sendingFacility) {
        this.sendingFacility = sendingFacility;
    }

    public String getReceivingApplication() {
        return this.receivingApplication;
    }

    public void setReceivingApplication(String receivingApplication) {
        this.receivingApplication = receivingApplication;
    }

    public String getReceivingFacility() {
        return this.receivingFacility;
    }

    public void setReceivingFacility(String receivingFacility) {
        this.receivingFacility = receivingFacility;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getMessageControlId() {
        return this.messageControlId;
    }

    public void setMessageControlId(String messageControlId) {
        this.messageControlId = messageControlId;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }
}

