/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2;

import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openehealth.ipf.commons.ihe.core.IntegrationProfile;
import org.openehealth.ipf.commons.ihe.core.InteractionId;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2InteractionId;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2TransactionConfiguration;
import org.openehealth.ipf.commons.ihe.hl7v2.NakFactory;
import org.openehealth.ipf.commons.ihe.hl7v2.QpdAwareNakFactory;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.FeedAuditDataset;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.QueryAuditDataset;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.iti10.Iti10AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.iti8.Iti8AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.iti9.Iti9AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.CustomModelClassUtils;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.HapiContextFactory;
import org.openehealth.ipf.gazelle.validation.profile.HL7v2Transactions;
import org.openehealth.ipf.gazelle.validation.profile.pixpdq.PixPdqTransactions;

public class PIX
implements IntegrationProfile {
    private static final Hl7v2TransactionConfiguration<FeedAuditDataset> ITI_8_CONFIGURATION = new Hl7v2TransactionConfiguration("pix-iti8", "Patient Identity Feed", false, new Iti8AuditStrategy(false), new Iti8AuditStrategy(true), Version.V231, "PIX adapter", "IPF", ErrorCode.APPLICATION_INTERNAL_ERROR, ErrorCode.APPLICATION_INTERNAL_ERROR, "ADT", "A01 A04 A05 A08 A40", "ACK", "*", true, false, HapiContextFactory.createHapiContext((ModelClassFactory)CustomModelClassUtils.createFactory("pix", "2.3.1"), (HL7v2Transactions)PixPdqTransactions.ITI8));
    private static final NakFactory<FeedAuditDataset> ITI_8_NAK_FACTORY = new NakFactory<FeedAuditDataset>(ITI_8_CONFIGURATION);
    private static final Hl7v2TransactionConfiguration<QueryAuditDataset> ITI_9_CONFIGURATION = new Hl7v2TransactionConfiguration("pix-iti9", "PIX Query", true, new Iti9AuditStrategy(false), new Iti9AuditStrategy(true), Version.V25, "PIX adapter", "IPF", ErrorCode.APPLICATION_INTERNAL_ERROR, ErrorCode.APPLICATION_INTERNAL_ERROR, "QBP", "Q23", "RSP", "K23", true, false, HapiContextFactory.createHapiContext((ModelClassFactory)CustomModelClassUtils.createFactory("pix", "2.5"), (HL7v2Transactions)PixPdqTransactions.ITI9));
    private static final NakFactory<QueryAuditDataset> ITI_9_NAK_FACTORY = new QpdAwareNakFactory(ITI_9_CONFIGURATION, "RSP", "K23");
    private static final Hl7v2TransactionConfiguration<QueryAuditDataset> ITI_10_CONFIGURATION = new Hl7v2TransactionConfiguration("pix-iti10", "PIX Update Notification", false, new Iti10AuditStrategy(false), new Iti10AuditStrategy(true), Version.V25, "PIX adapter", "IPF", ErrorCode.APPLICATION_INTERNAL_ERROR, ErrorCode.APPLICATION_INTERNAL_ERROR, "ADT", "A31", "ACK", "*", true, false, HapiContextFactory.createHapiContext((HL7v2Transactions)PixPdqTransactions.ITI10));
    private static final NakFactory<QueryAuditDataset> ITI_10_NAK_FACTORY = new NakFactory<QueryAuditDataset>(ITI_10_CONFIGURATION);

    public List<InteractionId> getInteractionIds() {
        ArrayList<Enum> interactions = new ArrayList<Enum>();
        interactions.addAll(Arrays.asList(FeedInteractions.values()));
        interactions.addAll(Arrays.asList(QueryInteractions.values()));
        return Collections.unmodifiableList(interactions);
    }

    static /* synthetic */ Hl7v2TransactionConfiguration access$0() {
        return ITI_8_CONFIGURATION;
    }

    static /* synthetic */ NakFactory access$1() {
        return ITI_8_NAK_FACTORY;
    }

    static /* synthetic */ Hl7v2TransactionConfiguration access$2() {
        return ITI_9_CONFIGURATION;
    }

    static /* synthetic */ NakFactory access$3() {
        return ITI_9_NAK_FACTORY;
    }

    static /* synthetic */ Hl7v2TransactionConfiguration access$4() {
        return ITI_10_CONFIGURATION;
    }

    static /* synthetic */ NakFactory access$5() {
        return ITI_10_NAK_FACTORY;
    }

    public static enum FeedInteractions implements Hl7v2InteractionId<FeedAuditDataset>
    {
        ITI_8_PIX(PIX.access$0(), PIX.access$1()),
        ITI_8_XDS(PIX.access$0(), PIX.access$1());

        private Hl7v2TransactionConfiguration<FeedAuditDataset> hl7v2TransactionConfiguration;
        private NakFactory<FeedAuditDataset> nakFactory;

        @Override
        public Hl7v2TransactionConfiguration<FeedAuditDataset> getHl7v2TransactionConfiguration() {
            return this.hl7v2TransactionConfiguration;
        }

        @Override
        public NakFactory<FeedAuditDataset> getNakFactory() {
            return this.nakFactory;
        }

        private FeedInteractions(Hl7v2TransactionConfiguration<FeedAuditDataset> hl7v2TransactionConfiguration, NakFactory<FeedAuditDataset> nakFactory) {
            this.hl7v2TransactionConfiguration = hl7v2TransactionConfiguration;
            this.nakFactory = nakFactory;
        }
    }

    public static enum QueryInteractions implements Hl7v2InteractionId
    {
        ITI_9(PIX.access$2(), PIX.access$3()),
        ITI_10(PIX.access$4(), PIX.access$5());

        private Hl7v2TransactionConfiguration<QueryAuditDataset> hl7v2TransactionConfiguration;
        private NakFactory<QueryAuditDataset> nakFactory;

        public Hl7v2TransactionConfiguration<QueryAuditDataset> getHl7v2TransactionConfiguration() {
            return this.hl7v2TransactionConfiguration;
        }

        public NakFactory<QueryAuditDataset> getNakFactory() {
            return this.nakFactory;
        }

        private QueryInteractions(Hl7v2TransactionConfiguration<QueryAuditDataset> hl7v2TransactionConfiguration, NakFactory<QueryAuditDataset> nakFactory) {
            this.hl7v2TransactionConfiguration = hl7v2TransactionConfiguration;
            this.nakFactory = nakFactory;
        }
    }
}

