/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2;

import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.Arrays;
import java.util.List;
import org.openehealth.ipf.commons.ihe.core.IntegrationProfile;
import org.openehealth.ipf.commons.ihe.core.InteractionId;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2InteractionId;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2TransactionConfiguration;
import org.openehealth.ipf.commons.ihe.hl7v2.NakFactory;
import org.openehealth.ipf.commons.ihe.hl7v2.PdqTransactionConfiguration;
import org.openehealth.ipf.commons.ihe.hl7v2.QpdAwareNakFactory;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.QueryAuditDataset;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.iti21.Iti21AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.iti22.Iti22AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.CustomModelClassUtils;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.HapiContextFactory;
import org.openehealth.ipf.gazelle.validation.profile.HL7v2Transactions;
import org.openehealth.ipf.gazelle.validation.profile.pixpdq.PixPdqTransactions;

public class PDQ
implements IntegrationProfile {
    private static final Hl7v2TransactionConfiguration<QueryAuditDataset> ITI_21_CONFIGURATION;
    private static final NakFactory<QueryAuditDataset> ITI_21_NAK_FACTORY;
    private static final Hl7v2TransactionConfiguration<QueryAuditDataset> ITI_22_CONFIGURATION;
    private static final NakFactory<QueryAuditDataset> ITI_22_NAK_FACTORY;

    static {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        ITI_21_CONFIGURATION = new PdqTransactionConfiguration("pdq-iti21", "Patient Demographics Query", true, (AuditStrategy<QueryAuditDataset>)new Iti21AuditStrategy(false), (AuditStrategy<QueryAuditDataset>)new Iti21AuditStrategy(true), new Version[]{Version.V25}, "PDQ adapter", "IPF", ErrorCode.APPLICATION_INTERNAL_ERROR, ErrorCode.APPLICATION_INTERNAL_ERROR, new String[]{"QBP", "QCN"}, new String[]{"Q22", "J01"}, new String[]{"RSP", "ACK"}, new String[]{"K22", "*"}, blArray, blArray2, HapiContextFactory.createHapiContext((ModelClassFactory)CustomModelClassUtils.createFactory("pdq", "2.5"), (HL7v2Transactions)PixPdqTransactions.ITI21));
        ITI_21_NAK_FACTORY = new QpdAwareNakFactory(ITI_21_CONFIGURATION, "RSP", "K22");
        boolean[] blArray3 = new boolean[2];
        blArray3[0] = true;
        boolean[] blArray4 = new boolean[2];
        blArray4[0] = true;
        ITI_22_CONFIGURATION = new PdqTransactionConfiguration("pdq-iti22", "Patient Demographics And Visit Query", true, (AuditStrategy<QueryAuditDataset>)new Iti22AuditStrategy(false), (AuditStrategy<QueryAuditDataset>)new Iti22AuditStrategy(true), new Version[]{Version.V25}, "PDQ adapter", "IPF", ErrorCode.APPLICATION_INTERNAL_ERROR, ErrorCode.APPLICATION_INTERNAL_ERROR, new String[]{"QBP", "QCN"}, new String[]{"ZV1", "J01"}, new String[]{"RSP", "ACK"}, new String[]{"ZV2", "*"}, blArray3, blArray4, HapiContextFactory.createHapiContext((ModelClassFactory)CustomModelClassUtils.createFactory("pdq", "2.5"), (HL7v2Transactions)PixPdqTransactions.ITI22));
        ITI_22_NAK_FACTORY = new QpdAwareNakFactory(ITI_22_CONFIGURATION, "RSP", "ZV2");
    }

    public List<InteractionId> getInteractionIds() {
        return Arrays.asList(Interactions.values());
    }

    static /* synthetic */ Hl7v2TransactionConfiguration access$0() {
        return ITI_21_CONFIGURATION;
    }

    static /* synthetic */ NakFactory access$1() {
        return ITI_21_NAK_FACTORY;
    }

    static /* synthetic */ Hl7v2TransactionConfiguration access$2() {
        return ITI_22_CONFIGURATION;
    }

    static /* synthetic */ NakFactory access$3() {
        return ITI_22_NAK_FACTORY;
    }

    public static enum Interactions implements Hl7v2InteractionId<QueryAuditDataset>
    {
        ITI_21(PDQ.access$0(), PDQ.access$1()),
        ITI_22(PDQ.access$2(), PDQ.access$3());

        private Hl7v2TransactionConfiguration<QueryAuditDataset> hl7v2TransactionConfiguration;
        private NakFactory<QueryAuditDataset> nakFactory;

        @Override
        public Hl7v2TransactionConfiguration<QueryAuditDataset> getHl7v2TransactionConfiguration() {
            return this.hl7v2TransactionConfiguration;
        }

        @Override
        public NakFactory<QueryAuditDataset> getNakFactory() {
            return this.nakFactory;
        }

        private Interactions(Hl7v2TransactionConfiguration<QueryAuditDataset> hl7v2TransactionConfiguration, NakFactory<QueryAuditDataset> nakFactory) {
            this.hl7v2TransactionConfiguration = hl7v2TransactionConfiguration;
            this.nakFactory = nakFactory;
        }
    }
}

