/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2;

import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.Version;
import java.util.Arrays;
import java.util.List;
import org.openehealth.ipf.commons.ihe.core.IntegrationProfile;
import org.openehealth.ipf.commons.ihe.core.InteractionId;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.HL7v2TransactionOption;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2InteractionId;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2TransactionConfiguration;
import org.openehealth.ipf.commons.ihe.hl7v2.NakFactory;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.FeedAuditDataset;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.iti30.Iti30AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.iti31.Iti31AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.HapiContextFactory;
import org.openehealth.ipf.gazelle.validation.profile.HL7v2Transactions;
import org.openehealth.ipf.gazelle.validation.profile.pam.PamTransactions;

public class PAM
implements IntegrationProfile {
    public List<InteractionId> getInteractionIds() {
        return Arrays.asList(Interactions.values());
    }

    public static enum Interactions implements Hl7v2InteractionId<FeedAuditDataset>
    {
        ITI_30{

            @Override
            public void init(List<? extends HL7v2TransactionOption> options) {
                this.init("pam-iti30", "Patient Identity Management", false, (AuditStrategy<FeedAuditDataset>)new Iti30AuditStrategy(false), (AuditStrategy<FeedAuditDataset>)new Iti30AuditStrategy(true), PamTransactions.ITI30, options);
            }
        }
        ,
        ITI_31{

            @Override
            public void init(List<? extends HL7v2TransactionOption> options) {
                this.init("pam-iti31", "Patient Encounter Management", false, (AuditStrategy<FeedAuditDataset>)new Iti31AuditStrategy(false), (AuditStrategy<FeedAuditDataset>)new Iti31AuditStrategy(true), PamTransactions.ITI31, options);
            }
        };

        private Hl7v2TransactionConfiguration<FeedAuditDataset> hl7v2TransactionConfiguration;
        private NakFactory<FeedAuditDataset> nakFactory;

        protected void init(String name, String description, boolean isQuery, AuditStrategy<FeedAuditDataset> clientAuditStrategy, AuditStrategy<FeedAuditDataset> serverAuditStrategy, PamTransactions pamTransactions, List<? extends HL7v2TransactionOption> options) {
            this.hl7v2TransactionConfiguration = new Hl7v2TransactionConfiguration<FeedAuditDataset>(name, description, isQuery, clientAuditStrategy, serverAuditStrategy, new Version[]{Version.V25}, "PIM adapter", "IPF", ErrorCode.APPLICATION_INTERNAL_ERROR, ErrorCode.APPLICATION_INTERNAL_ERROR, new String[]{"ADT"}, new String[]{HL7v2TransactionOption.concatAllToString(options)}, new String[]{"ACK"}, new String[]{"*"}, new boolean[]{true}, new boolean[1], HapiContextFactory.createHapiContext((HL7v2Transactions)pamTransactions));
            this.nakFactory = new NakFactory<FeedAuditDataset>(this.hl7v2TransactionConfiguration);
        }

        @Override
        public Hl7v2TransactionConfiguration<FeedAuditDataset> getHl7v2TransactionConfiguration() {
            return this.hl7v2TransactionConfiguration;
        }

        @Override
        public NakFactory<FeedAuditDataset> getNakFactory() {
            return this.nakFactory;
        }
    }
}

