/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.openehealth.ipf.commons.ihe.core.TransactionOptions;

public interface HL7v2TransactionOption
extends TransactionOptions<String> {
    public static List<String> concat(HL7v2TransactionOption options, List<String> suffix) {
        if (suffix != null && !suffix.isEmpty()) {
            HashSet<String> events = new HashSet<String>(options.getSupportedThings());
            events.addAll(suffix);
            return new ArrayList<String>(events);
        }
        return options.getSupportedThings();
    }

    public static List<String> concat(HL7v2TransactionOption option, HL7v2TransactionOption otherOption, List<String> suffix) {
        List<String> events = HL7v2TransactionOption.concat(otherOption, suffix);
        return HL7v2TransactionOption.concat(option, events);
    }

    public static <T extends HL7v2TransactionOption> String concatAllToString(List<? extends T> options) {
        return options.stream().flatMap(o -> o.getSupportedThings().stream()).map(Object::toString).collect(Collectors.joining(" "));
    }
}

