/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.queue;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.audit.queue.AbstractMockedAuditMessageQueue;

public class RecordingAuditMessageQueue
implements AbstractMockedAuditMessageQueue {
    private List<AuditMessage> messages = new CopyOnWriteArrayList<AuditMessage>();

    @Override
    public void audit(AuditContext auditContext, AuditMessage ... auditMessages) {
        this.messages.addAll(Arrays.asList(auditMessages));
    }

    @Override
    public List<AuditMessage> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public Optional<AuditMessage> getFirstMessage() {
        return this.getMessages().stream().findFirst();
    }

    @Override
    public void clear() {
        this.messages.clear();
    }
}

