/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.queue;

import java.util.Objects;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsAuditMessageListener
implements MessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(JmsAuditMessageListener.class);
    private final AuditContext auditContext;

    public JmsAuditMessageListener(AuditContext auditContext) {
        this.auditContext = Objects.requireNonNull(auditContext, "AuditContext must not be null");
    }

    public void onMessage(Message message) {
        TextMessage textMessage = (TextMessage)message;
        try {
            String text = textMessage.getText();
            this.auditContext.getAuditTransmissionProtocol().send(this.auditContext, text);
        }
        catch (JMSException jmsException1) {
            LOG.error("Could not obtain text from JMS message", (Throwable)jmsException1);
        }
        catch (Exception e) {
            LOG.warn("Could not send audit message, rolling back", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

