/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.protocol;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.buffer.impl.BufferImpl;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.PfxOptions;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionProtocol;
import org.openehealth.ipf.commons.audit.protocol.RFC5424Protocol;
import org.openehealth.ipf.commons.audit.utils.AuditUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxTLSSyslogSenderImpl
extends RFC5424Protocol
implements AuditTransmissionProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(VertxTLSSyslogSenderImpl.class);
    private volatile AtomicReference<String> writeHandlerId = new AtomicReference();
    private final Vertx vertx;
    private boolean trustAll;

    public VertxTLSSyslogSenderImpl() {
        this(Vertx.vertx());
    }

    public VertxTLSSyslogSenderImpl(Vertx vertx) {
        super(AuditUtils.getLocalHostName(), AuditUtils.getProcessId());
        this.vertx = vertx;
    }

    @Override
    public void send(AuditContext auditContext, String ... auditMessages) {
        if (auditMessages != null) {
            for (String auditMessage : auditMessages) {
                byte[] msgBytes = this.getTransportPayload(auditContext.getSendingApplication(), auditMessage);
                byte[] syslogFrame = String.format("%d ", msgBytes.length).getBytes();
                LOG.debug("Auditing to {}:{}", (Object)auditContext.getAuditRepositoryAddress().getHostAddress(), (Object)auditContext.getAuditRepositoryPort());
                LOG.trace("{}", (Object)new String(msgBytes, StandardCharsets.UTF_8));
                Buffer buffer = new BufferImpl().appendBytes(syslogFrame).appendBytes(msgBytes);
                this.vertx.eventBus().send(this.ensureEstablishedConnection(auditContext), (Object)buffer);
            }
        }
    }

    @Override
    public String getTransportName() {
        return "NIO-TLS";
    }

    @Override
    public void shutdown() {
        this.vertx.close();
    }

    private String ensureEstablishedConnection(AuditContext auditContext) {
        if (this.writeHandlerId.get() == null) {
            CountDownLatch latch = new CountDownLatch(1);
            NetClientOptions options = new NetClientOptions().setConnectTimeout(1000).setReconnectAttempts(5).setReconnectInterval(1000L).setSsl(true);
            if (this.trustAll) {
                options.setTrustAll(true);
            } else {
                this.initializeTLSParameters(options);
            }
            NetClient client = this.vertx.createNetClient(options);
            client.connect(auditContext.getAuditRepositoryPort(), auditContext.getAuditRepositoryAddress().getHostAddress(), event -> {
                LOG.info("Attempt to connect to {}:{} : {}", new Object[]{auditContext.getAuditRepositoryAddress().getHostAddress(), auditContext.getAuditRepositoryPort(), event.succeeded()});
                if (event.succeeded()) {
                    NetSocket socket = (NetSocket)event.result();
                    socket.exceptionHandler(exceptionEvent -> {
                        LOG.info("Audit Connection caught exception", exceptionEvent);
                        this.writeHandlerId.set(null);
                        client.close();
                    }).closeHandler(closeEvent -> {
                        LOG.info("Audit Connection closed");
                        this.writeHandlerId.set(null);
                        client.close();
                    });
                    this.writeHandlerId.compareAndSet(null, socket.writeHandlerID());
                    latch.countDown();
                }
            });
            try {
                latch.await(10000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new AuditException(String.format("Could not establish TLS connection to %s:%d", auditContext.getAuditRepositoryAddress().getHostAddress(), auditContext.getAuditRepositoryPort()));
            }
        }
        return this.writeHandlerId.get();
    }

    private void initializeTLSParameters(NetClientOptions options) {
        String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
        if ("JKS".equalsIgnoreCase(keyStoreType)) {
            options.setKeyStoreOptions(new JksOptions().setPath(System.getProperty("javax.net.ssl.keyStore")).setPassword(System.getProperty("javax.net.ssl.keyStorePassword")));
        } else {
            options.setPfxKeyCertOptions(new PfxOptions().setPath(System.getProperty("javax.net.ssl.keyStore")).setPassword(System.getProperty("javax.net.ssl.keyStorePassword")));
        }
        String trustStoreType = System.getProperty("javax.net.ssl.trustStoretype", KeyStore.getDefaultType());
        if ("JKS".equalsIgnoreCase(trustStoreType)) {
            options.setTrustStoreOptions(new JksOptions().setPath(System.getProperty("javax.net.ssl.trustStore")).setPassword(System.getProperty("javax.net.ssl.trustStorePassword")));
        } else {
            options.setPfxTrustOptions(new PfxOptions().setPath(System.getProperty("javax.net.ssl.trustStore")).setPassword(System.getProperty("javax.net.ssl.trustStorePassword")));
        }
        String allowedProtocols = System.getProperty("jdk.tls.client.protocols", "TLSv1.2");
        Stream.of(allowedProtocols.split("\\s*,\\s*")).forEach(arg_0 -> ((NetClientOptions)options).addEnabledSecureTransportProtocol(arg_0));
        String allowedCiphers = System.getProperty("https.ciphersuites");
        if (allowedCiphers != null) {
            Stream.of(allowedCiphers.split("\\s*,\\s*")).forEach(arg_0 -> ((NetClientOptions)options).addEnabledCipherSuite(arg_0));
        }
    }

    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }
}

