/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.protocol;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.nio.charset.StandardCharsets;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionProtocol;
import org.openehealth.ipf.commons.audit.protocol.RFC5424Protocol;
import org.openehealth.ipf.commons.audit.utils.AuditUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDPSyslogSenderImpl
extends RFC5424Protocol
implements AuditTransmissionProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(UDPSyslogSenderImpl.class);
    private static final int MAX_DATAGRAM_PACKET_SIZE = 65479;

    public UDPSyslogSenderImpl() {
        this(AuditUtils.getLocalHostName(), AuditUtils.getProcessId());
    }

    public UDPSyslogSenderImpl(String sendingHost, String sendingProcess) {
        super(sendingHost, sendingProcess);
    }

    @Override
    public String getTransportName() {
        return "UDP";
    }

    @Override
    public void send(AuditContext auditContext, String ... auditMessages) throws Exception {
        if (auditMessages != null) {
            try (DatagramSocket socket = new DatagramSocket();){
                for (String auditMessage : auditMessages) {
                    byte[] msgBytes = this.getTransportPayload(auditContext.getSendingApplication(), auditMessage);
                    LOG.debug("Auditing to {}:{}", (Object)auditContext.getAuditRepositoryAddress().getHostAddress(), (Object)auditContext.getAuditRepositoryPort());
                    LOG.trace("{}", (Object)new String(msgBytes, StandardCharsets.UTF_8));
                    DatagramPacket packet = new DatagramPacket(msgBytes, Math.min(65479, msgBytes.length), auditContext.getAuditRepositoryAddress(), auditContext.getAuditRepositoryPort());
                    socket.send(packet);
                }
            }
        }
    }

    @Override
    public void shutdown() {
    }
}

