/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.protocol;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSocketFactory;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionProtocol;
import org.openehealth.ipf.commons.audit.protocol.RFC5424Protocol;
import org.openehealth.ipf.commons.audit.utils.AuditUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLSSyslogSenderImpl
extends RFC5424Protocol
implements AuditTransmissionProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(TLSSyslogSenderImpl.class);
    private AtomicReference<Socket> socket = new AtomicReference();

    public TLSSyslogSenderImpl() {
        this(AuditUtils.getLocalHostName(), AuditUtils.getProcessId());
    }

    public TLSSyslogSenderImpl(String sendingHost, String sendingProcess) {
        super(sendingHost, sendingProcess);
    }

    @Override
    public String getTransportName() {
        return "TLS";
    }

    private Socket getSocket(AuditContext auditContext) {
        if (this.socket.get() == null) {
            this.socket.compareAndSet(null, this.getTLSSocket(auditContext));
        }
        return this.socket.get();
    }

    @Override
    public void send(AuditContext auditContext, String ... auditMessages) throws Exception {
        if (auditMessages != null) {
            for (String auditMessage : auditMessages) {
                byte[] msgBytes = this.getTransportPayload(auditContext.getSendingApplication(), auditMessage);
                byte[] syslogFrame = String.format("%d ", msgBytes.length).getBytes();
                LOG.debug("Auditing to {}:{}", (Object)auditContext.getAuditRepositoryAddress().getHostAddress(), (Object)auditContext.getAuditRepositoryPort());
                LOG.trace("{}", (Object)new String(msgBytes, StandardCharsets.UTF_8));
                try {
                    this.doSend(auditContext, syslogFrame, msgBytes);
                }
                catch (SocketException e) {
                    try {
                        LOG.info("Failed to use existing TLS socket. Will create a new connection and retry.");
                        this.socket.set(null);
                        this.doSend(auditContext, syslogFrame, msgBytes);
                    }
                    catch (Exception exception) {
                        LOG.error("Failed to audit using new TLS socket, giving up - this audit message will be lost.");
                        this.socket.set(null);
                        throw exception;
                    }
                }
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.socket.get() != null) {
            try {
                this.socket.get().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private synchronized void doSend(AuditContext auditContext, byte[] syslogFrame, byte[] msgBytes) throws IOException {
        Socket socket = this.getSocket(auditContext);
        OutputStream out = socket.getOutputStream();
        out.write(syslogFrame);
        out.write(msgBytes);
        out.flush();
    }

    private Socket getTLSSocket(AuditContext auditContext) {
        try {
            return SSLSocketFactory.getDefault().createSocket(auditContext.getAuditRepositoryAddress(), auditContext.getAuditRepositoryPort());
        }
        catch (IOException e) {
            throw new AuditException(String.format("Could not establish TLS connection to %s:%d", auditContext.getAuditRepositoryAddress().getHostAddress(), auditContext.getAuditRepositoryPort()), e);
        }
    }
}

