/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.protocol;

import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Objects;

public class RFC5424Protocol {
    private static final int TRANSPORT_PRI = 85;
    private static final String TRANSPORT_MSGID = "IHE+RFC-3881";
    private final String senderHostName;
    private final String senderProcessId;

    public RFC5424Protocol(String senderHostName, String senderProcessId) {
        this.senderHostName = Objects.requireNonNull(senderHostName);
        this.senderProcessId = Objects.requireNonNull(senderProcessId);
    }

    protected byte[] getTransportPayload(String sendingApplication, String auditMessage) {
        String msg = String.format("<%s>1 %s %s %s %s %s - \ufeff<?xml version=\"1.0\" encoding=\"UTF-8\"?>%s", 85, Instant.now(), this.senderHostName, sendingApplication, this.senderProcessId, TRANSPORT_MSGID, auditMessage);
        return msg.trim().getBytes(StandardCharsets.UTF_8);
    }
}

