/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.event;

import java.util.Collections;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventIdCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectIdTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCodeRole;
import org.openehealth.ipf.commons.audit.event.BaseAuditMessageBuilder;
import org.openehealth.ipf.commons.audit.types.ActiveParticipantRoleId;
import org.openehealth.ipf.commons.audit.types.EventId;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;

public class SecurityAlertBuilder
extends BaseAuditMessageBuilder<SecurityAlertBuilder> {
    public SecurityAlertBuilder(EventOutcomeIndicator outcome, String eventOutcomeDescription, EventType eventType) {
        this.setEventIdentification(outcome, eventOutcomeDescription, EventActionCode.Execute, (EventId)EventIdCode.SecurityAlert, eventType, (PurposeOfUse[])null);
    }

    public SecurityAlertBuilder addReportingActiveParticipant(String userId, String altUserId, String userName, ActiveParticipantRoleId roleId, String networkId, boolean userIsRequestor) {
        return (SecurityAlertBuilder)this.addActiveParticipant(userId, altUserId, userName, userIsRequestor, Collections.singletonList(roleId), networkId);
    }

    public SecurityAlertBuilder addPerformingActiveParticipant(String userId, String altUserId, String userName, ActiveParticipantRoleId roleId, String networkId) {
        return (SecurityAlertBuilder)this.addActiveParticipant(userId, altUserId, userName, false, Collections.singletonList(roleId), networkId);
    }

    public SecurityAlertBuilder addAlertNodeSubjectParticipantObject(String node, ParticipantObjectTypeCodeRole role, String reason) {
        return (SecurityAlertBuilder)this.addParticipantObjectIdentification(ParticipantObjectIdTypeCode.NodeID, null, null, reason != null ? Collections.singletonList(this.getTypeValuePair("Alert Description", reason)) : Collections.emptyList(), node, ParticipantObjectTypeCode.System, role, null, null);
    }

    public SecurityAlertBuilder addAlertUriSubjectParticipantObject(String uri, ParticipantObjectTypeCodeRole role, String reason) {
        return (SecurityAlertBuilder)this.addParticipantObjectIdentification(ParticipantObjectIdTypeCode.URI, null, null, reason != null ? Collections.singletonList(this.getTypeValuePair("Alert Description", reason)) : Collections.emptyList(), uri, ParticipantObjectTypeCode.System, role, null, null);
    }

    @Override
    public void validate() {
        super.validate();
        int aps = this.getMessage().getActiveParticipants().size();
        if (aps < 1 || aps > 2) {
            throw new AuditException("Must have one or two ActiveParticipants reporting this event");
        }
    }
}

