/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.event;

import java.util.Collections;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.codes.ActiveParticipantRoleIdCode;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventIdCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.event.BaseAuditMessageBuilder;
import org.openehealth.ipf.commons.audit.types.ActiveParticipantRoleId;
import org.openehealth.ipf.commons.audit.types.EventId;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;

public class QueryBuilder
extends BaseAuditMessageBuilder<QueryBuilder> {
    public QueryBuilder(EventOutcomeIndicator outcome, EventType eventType, PurposeOfUse ... purposesOfUse) {
        this(outcome, null, eventType, purposesOfUse);
    }

    public QueryBuilder(EventOutcomeIndicator outcome, String eventOutcomeDescription, EventType eventType, PurposeOfUse ... purposesOfUse) {
        this.setEventIdentification(outcome, eventOutcomeDescription, EventActionCode.Execute, (EventId)EventIdCode.Query, eventType, purposesOfUse);
    }

    public QueryBuilder setQueryingParticipant(String userId, String altUserId, String userName, String networkAccessPointId, boolean userIsRequestor) {
        return (QueryBuilder)this.addSourceActiveParticipant(userId, altUserId, userName, networkAccessPointId, userIsRequestor);
    }

    public QueryBuilder setRespondingParticipant(String userId, String altUserId, String userName, String networkAccessPointId, boolean userIsRequestor) {
        return (QueryBuilder)this.addDestinationActiveParticipant(userId, altUserId, userName, networkAccessPointId, userIsRequestor);
    }

    public QueryBuilder addOtherActiveParticipant(String userId, String altUserId, String userName, ActiveParticipantRoleId roleId, String networkId, boolean userIsRequestor) {
        return (QueryBuilder)this.addActiveParticipant(userId, altUserId, userName, userIsRequestor, Collections.singletonList(roleId), networkId);
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getMessage().findActiveParticipants(ap -> ap.getRoleIDCodes().contains(ActiveParticipantRoleIdCode.Source)).size() != 1) {
            throw new AuditException("Must have one ActiveParticipant with RoleIDCode Source");
        }
        if (this.getMessage().findActiveParticipants(ap -> ap.getRoleIDCodes().contains(ActiveParticipantRoleIdCode.Destination)).size() != 1) {
            throw new AuditException("Must have one ActiveParticipant with RoleIDCode Destination");
        }
    }
}

