/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.codes;

import org.openehealth.ipf.commons.audit.types.AuditSource;
import org.openehealth.ipf.commons.audit.types.EnumeratedCodedValue;
import org.openehealth.ipf.commons.audit.types.EnumeratedValueSet;

public enum AuditSourceType implements EnumeratedCodedValue<AuditSource>,
AuditSource
{
    EndUserInterface("1", "End-user interface"),
    DataAcquisitionDevice("2", "Data acquisition device or instrument"),
    WebServerProcess("3", "Web Server Process or Thread"),
    ApplicationServerProcess("4", "Application Server Process or Thread"),
    DatabaseServerProcess("5", "Database Server Process or Thread"),
    SecurityServer("6", "Security Server"),
    NetworkComponent("7", "Network Component"),
    OperatingSoftware("8", "Operating Software"),
    Other("9", "Other");

    private AuditSource value;

    private AuditSourceType(String code, String displayName) {
        this.value = AuditSource.of(code, "DCM", displayName);
    }

    public static AuditSourceType enumForCode(String code) {
        return EnumeratedValueSet.enumForCode(AuditSourceType.class, code);
    }

    @Override
    public AuditSource getValue() {
        return this.value;
    }
}

