/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.AuditMessagePostProcessor;
import org.openehealth.ipf.commons.audit.codes.AuditSourceType;
import org.openehealth.ipf.commons.audit.handler.AuditExceptionHandler;
import org.openehealth.ipf.commons.audit.handler.LoggingAuditExceptionHandler;
import org.openehealth.ipf.commons.audit.marshal.SerializationStrategy;
import org.openehealth.ipf.commons.audit.marshal.dicom.Current;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionProtocol;
import org.openehealth.ipf.commons.audit.protocol.TLSSyslogSenderImpl;
import org.openehealth.ipf.commons.audit.protocol.UDPSyslogSenderImpl;
import org.openehealth.ipf.commons.audit.protocol.VertxTLSSyslogSenderImpl;
import org.openehealth.ipf.commons.audit.queue.AuditMessageQueue;
import org.openehealth.ipf.commons.audit.queue.SynchronousAuditMessageQueue;
import org.openehealth.ipf.commons.audit.types.AuditSource;
import org.openehealth.ipf.commons.audit.utils.AuditUtils;

public class DefaultAuditContext
implements AuditContext {
    static final AuditContext NO_AUDIT = new DefaultAuditContext();
    private String auditRepositoryHostName = "localhost";
    private InetAddress auditRepositoryAddress = AuditUtils.localInetAddress().orElse(null);
    private int auditRepositoryPort = 514;
    private boolean auditEnabled = false;
    private AuditTransmissionProtocol auditTransmissionProtocol = new UDPSyslogSenderImpl();
    private AuditMessageQueue auditMessageQueue = new SynchronousAuditMessageQueue();
    private String sendingApplication = "IPF";
    private String auditSourceId = "IPF";
    private String auditEnterpriseSiteId = "IPF";
    private AuditSource auditSource = AuditSourceType.Other;
    private SerializationStrategy serializationStrategy = new Current();
    private AuditMessagePostProcessor auditMessagePostProcessor = AuditMessagePostProcessor.noOp();
    private AuditExceptionHandler auditExceptionHandler = new LoggingAuditExceptionHandler();
    private boolean includeParticipantsFromResponse = false;

    public void setAuditRepositoryHost(String auditRepositoryHost) throws UnknownHostException {
        this.auditRepositoryHostName = auditRepositoryHost;
        this.auditRepositoryAddress = InetAddress.getByName(auditRepositoryHost);
    }

    public String getAuditRepositoryTransport() {
        return this.auditTransmissionProtocol.getTransportName();
    }

    public void setAuditRepositoryTransport(String transport) {
        switch (transport) {
            case "UDP": {
                this.setAuditTransmissionProtocol(new UDPSyslogSenderImpl());
                break;
            }
            case "TLS": {
                this.setAuditTransmissionProtocol(new TLSSyslogSenderImpl());
                break;
            }
            case "NIO-TLS": {
                this.setAuditTransmissionProtocol(new VertxTLSSyslogSenderImpl());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown transport :" + transport);
            }
        }
    }

    @Override
    public String getAuditRepositoryHostName() {
        return this.auditRepositoryHostName;
    }

    @Override
    public InetAddress getAuditRepositoryAddress() {
        return this.auditRepositoryAddress;
    }

    @Override
    public int getAuditRepositoryPort() {
        return this.auditRepositoryPort;
    }

    public void setAuditRepositoryPort(int auditRepositoryPort) {
        this.auditRepositoryPort = auditRepositoryPort;
    }

    @Override
    public boolean isAuditEnabled() {
        return this.auditEnabled;
    }

    @Override
    public void setAuditEnabled(boolean auditEnabled) {
        this.auditEnabled = auditEnabled;
    }

    @Override
    public AuditTransmissionProtocol getAuditTransmissionProtocol() {
        return this.auditTransmissionProtocol;
    }

    public void setAuditTransmissionProtocol(AuditTransmissionProtocol auditTransmissionProtocol) {
        this.auditTransmissionProtocol = auditTransmissionProtocol;
    }

    @Override
    public AuditMessageQueue getAuditMessageQueue() {
        return this.auditMessageQueue;
    }

    public void setAuditMessageQueue(AuditMessageQueue auditMessageQueue) {
        this.auditMessageQueue = auditMessageQueue;
    }

    @Override
    public String getSendingApplication() {
        return this.sendingApplication;
    }

    public void setSendingApplication(String sendingApplication) {
        this.sendingApplication = sendingApplication;
    }

    @Override
    public String getAuditSourceId() {
        return this.auditSourceId;
    }

    public void setAuditSourceId(String auditSourceId) {
        this.auditSourceId = auditSourceId;
    }

    @Override
    public String getAuditEnterpriseSiteId() {
        return this.auditEnterpriseSiteId;
    }

    public void setAuditEnterpriseSiteId(String auditEnterpriseSiteId) {
        this.auditEnterpriseSiteId = auditEnterpriseSiteId;
    }

    @Override
    public AuditSource getAuditSource() {
        return this.auditSource;
    }

    public void setAuditSource(AuditSource auditSource) {
        this.auditSource = auditSource;
    }

    @Override
    public SerializationStrategy getSerializationStrategy() {
        return this.serializationStrategy;
    }

    public void setSerializationStrategy(SerializationStrategy serializationStrategy) {
        this.serializationStrategy = serializationStrategy;
    }

    @Override
    public AuditMessagePostProcessor getAuditMessagePostProcessor() {
        return this.auditMessagePostProcessor;
    }

    public void setAuditMessagePostProcessor(AuditMessagePostProcessor auditMessagePostProcessor) {
        this.auditMessagePostProcessor = auditMessagePostProcessor;
    }

    @Override
    public AuditExceptionHandler getAuditExceptionHandler() {
        return this.auditExceptionHandler;
    }

    public void setAuditExceptionHandler(AuditExceptionHandler auditExceptionHandler) {
        this.auditExceptionHandler = auditExceptionHandler;
    }

    @Override
    public boolean isIncludeParticipantsFromResponse() {
        return this.includeParticipantsFromResponse;
    }

    public void setIncludeParticipantsFromResponse(boolean includeParticipantsFromResponse) {
        this.includeParticipantsFromResponse = includeParticipantsFromResponse;
    }
}

