/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit;

import java.net.InetAddress;
import java.util.stream.Stream;
import org.openehealth.ipf.commons.audit.AuditMessagePostProcessor;
import org.openehealth.ipf.commons.audit.DefaultAuditContext;
import org.openehealth.ipf.commons.audit.handler.AuditExceptionHandler;
import org.openehealth.ipf.commons.audit.marshal.SerializationStrategy;
import org.openehealth.ipf.commons.audit.marshal.dicom.Current;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionProtocol;
import org.openehealth.ipf.commons.audit.queue.AuditMessageQueue;
import org.openehealth.ipf.commons.audit.types.AuditSource;

public interface AuditContext {
    public boolean isAuditEnabled();

    public void setAuditEnabled(boolean var1);

    public String getAuditRepositoryHostName();

    public InetAddress getAuditRepositoryAddress();

    public int getAuditRepositoryPort();

    public String getSendingApplication();

    public AuditTransmissionProtocol getAuditTransmissionProtocol();

    public AuditMessageQueue getAuditMessageQueue();

    default public AuditMessagePostProcessor getAuditMessagePostProcessor() {
        return AuditMessagePostProcessor.noOp();
    }

    default public SerializationStrategy getSerializationStrategy() {
        return Current.INSTANCE;
    }

    default public void audit(AuditMessage ... messages) {
        this.getAuditMessageQueue().audit(this, (AuditMessage[])Stream.of(messages).map(this.getAuditMessagePostProcessor()).toArray(AuditMessage[]::new));
    }

    public String getAuditSourceId();

    public String getAuditEnterpriseSiteId();

    public AuditSource getAuditSource();

    public AuditExceptionHandler getAuditExceptionHandler();

    public boolean isIncludeParticipantsFromResponse();

    public static AuditContext noAudit() {
        return DefaultAuditContext.NO_AUDIT;
    }
}

