/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.boot;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.camel.support.jsse.CipherSuitesParameters;
import org.apache.camel.support.jsse.ClientAuthentication;
import org.apache.camel.support.jsse.KeyManagersParameters;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.apache.camel.support.jsse.SSLContextClientParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.jsse.SSLContextServerParameters;
import org.apache.camel.support.jsse.SecureSocketProtocolsParameters;
import org.apache.camel.support.jsse.TrustManagersParameters;
import org.openehealth.ipf.boot.IpfConfigurationProperties;
import org.openehealth.ipf.commons.core.config.Registry;
import org.openehealth.ipf.commons.spring.core.config.SpringConfigurationPostProcessor;
import org.openehealth.ipf.commons.spring.core.config.SpringRegistry;
import org.openehealth.ipf.commons.spring.map.SpringBidiMappingService;
import org.openehealth.ipf.commons.spring.map.config.CustomMappingsConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.server.Ssl;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={IpfConfigurationProperties.class})
public class IpfAutoConfiguration {
    private final IpfConfigurationProperties ipfConfigurationProperties;

    public IpfAutoConfiguration(IpfConfigurationProperties ipfConfigurationProperties) {
        this.ipfConfigurationProperties = ipfConfigurationProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={Registry.class})
    Registry springRegistry() {
        return new SpringRegistry();
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringConfigurationPostProcessor.class})
    public SpringConfigurationPostProcessor postProcessor(CustomMappingsConfigurer customMappingsConfigurer) {
        SpringConfigurationPostProcessor processor = new SpringConfigurationPostProcessor();
        ArrayList<CustomMappingsConfigurer> list = new ArrayList<CustomMappingsConfigurer>();
        if (customMappingsConfigurer != null) {
            list.add(customMappingsConfigurer);
        }
        processor.setSpringConfigurers(list);
        return processor;
    }

    @Bean
    @ConditionalOnMissingBean(value={CustomMappingsConfigurer.class})
    protected CustomMappingsConfigurer customMappingsConfigurer(SpringBidiMappingService mappingService) {
        CustomMappingsConfigurer configurer = new CustomMappingsConfigurer();
        configurer.setMappingService(mappingService);
        return configurer;
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringBidiMappingService.class})
    public SpringBidiMappingService mappingService() {
        return new SpringBidiMappingService();
    }

    @Bean(name={"bootSslContextParameters"})
    @ConditionalOnProperty(prefix="ipf.commons", name={"reuse-ssl-config"})
    public SSLContextParameters sslContextParameters(ServerProperties serverProperties) {
        Ssl sslConfig = serverProperties.getSsl();
        KeyStoreParameters ksp = new KeyStoreParameters();
        ksp.setResource(this.resourceName(sslConfig.getKeyStore()));
        ksp.setPassword(sslConfig.getKeyStorePassword());
        ksp.setProvider(sslConfig.getKeyStoreProvider());
        ksp.setType(sslConfig.getKeyStoreType());
        KeyManagersParameters kmp = new KeyManagersParameters();
        kmp.setKeyStore(ksp);
        kmp.setKeyPassword(sslConfig.getKeyPassword());
        KeyStoreParameters tsp = new KeyStoreParameters();
        tsp.setResource(this.resourceName(sslConfig.getTrustStore()));
        tsp.setPassword(sslConfig.getTrustStorePassword());
        tsp.setProvider(sslConfig.getTrustStoreProvider());
        tsp.setType(sslConfig.getTrustStoreType());
        TrustManagersParameters tmp = new TrustManagersParameters();
        tmp.setKeyStore(tsp);
        SSLContextServerParameters scsp = new SSLContextServerParameters();
        if (sslConfig.getClientAuth() == Ssl.ClientAuth.WANT) {
            scsp.setClientAuthentication(ClientAuthentication.WANT.name());
        } else if (sslConfig.getClientAuth() == Ssl.ClientAuth.NEED) {
            scsp.setClientAuthentication(ClientAuthentication.REQUIRE.name());
        }
        SecureSocketProtocolsParameters sspp = new SecureSocketProtocolsParameters();
        sspp.setSecureSocketProtocol(Arrays.asList(sslConfig.getEnabledProtocols()));
        scsp.setSecureSocketProtocols(sspp);
        CipherSuitesParameters csp = new CipherSuitesParameters();
        csp.setCipherSuite(Arrays.asList(sslConfig.getCiphers()));
        scsp.setCipherSuites(csp);
        SSLContextClientParameters sccp = new SSLContextClientParameters();
        sccp.setSecureSocketProtocols(sspp);
        sccp.setCipherSuites(csp);
        SSLContextParameters scp = new SSLContextParameters();
        scp.setCertAlias(sslConfig.getKeyAlias());
        scp.setKeyManagers(kmp);
        scp.setTrustManagers(tmp);
        scp.setServerParameters(scsp);
        scp.setClientParameters(sccp);
        return scp;
    }

    private String resourceName(String resource) {
        int i = resource.indexOf(":");
        return i >= 0 ? resource.substring(i + 1) : resource;
    }
}

