/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.boot.hl7v3;

import org.openehealth.ipf.boot.atna.IpfAtnaAutoConfiguration;
import org.openehealth.ipf.boot.hl7v3.IpfHl7v3ConfigurationProperties;
import org.openehealth.ipf.commons.ihe.hl7v3.storage.Hl7v3ContinuationStorage;
import org.openehealth.ipf.commons.ihe.hl7v3.storage.SpringCacheHl7v3ContinuationStorage;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={IpfAtnaAutoConfiguration.class})
@EnableConfigurationProperties(value={IpfHl7v3ConfigurationProperties.class})
public class IpfHl7v3AutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={Hl7v3ContinuationStorage.class})
    @ConditionalOnSingleCandidate(value=CacheManager.class)
    @ConditionalOnProperty(value={"ipf.hl7v3.caching"})
    public Hl7v3ContinuationStorage hl7v3ContinuationStorage(CacheManager cacheManager) {
        return new SpringCacheHl7v3ContinuationStorage(cacheManager);
    }
}

