/*
 * Decompiled with CFR 0.152.
 */
package org.husky.communication.testhelper;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.husky.common.enums.CountryCode;
import org.husky.common.utils.DateUtil;
import org.husky.fhir.structures.gen.FhirCommon;
import org.husky.fhir.structures.gen.FhirPatient;

public class TestPatient {
    public static String oidInsuranceCard = FhirCommon.addUrnOid((String)"2.16.756.5.30.1.123.100.1.1.1");
    private static String oidLocalId = "1.2.3.4";
    public String given;
    public String family;
    public String birthDate;
    public String addrLine1;
    public String addrCity;
    public String addrState;
    public String addrCountry;
    public String addrUse;
    public String addrPostalCode;
    public String gender;
    public String idInsuranceCard;
    public String localId;

    public static FhirPatient getFhirPatientMueller() {
        FhirPatient patient = new FhirPatient();
        TestPatient testPatient = TestPatient.getTestPatientMueller();
        Address address = new Address().addLine(testPatient.addrLine1).setPostalCode(testPatient.addrPostalCode).setCity(testPatient.addrCity).setState(testPatient.addrState).setCountry(testPatient.addrCountry);
        address.setUse(Address.AddressUse.valueOf((String)testPatient.addrUse.toUpperCase()));
        HumanName humanName = new HumanName().setFamily(testPatient.family).addGiven(testPatient.given);
        patient.getName().add(humanName);
        Identifier identifier = new Identifier();
        identifier.setUse(Identifier.IdentifierUse.USUAL);
        identifier.setSystem(FhirCommon.addUrnOid((String)oidLocalId));
        identifier.setValue(testPatient.localId);
        patient.getIdentifier().add(identifier);
        patient.setBirthDate(DateUtil.parseDateyyyyMMdd2((String)testPatient.birthDate));
        patient.getAddress().add(address);
        patient.setGender(Enumerations.AdministrativeGender.valueOf((String)testPatient.gender.toUpperCase()));
        return patient;
    }

    public static FhirPatient getFhirPatientMuellerObsoleteId() {
        FhirPatient patient = new FhirPatient();
        TestPatient testPatient = TestPatient.getTestPatientMuellerObsolete();
        Address address = new Address().addLine(testPatient.addrLine1).setPostalCode(testPatient.addrPostalCode).setCity(testPatient.addrCity).setState(testPatient.addrState).setCountry(testPatient.addrCountry);
        address.setUse(Address.AddressUse.valueOf((String)testPatient.addrUse.toUpperCase()));
        HumanName humanName = new HumanName().setFamily(testPatient.family).addGiven(testPatient.given);
        patient.getName().add(humanName);
        Identifier identifier = new Identifier();
        identifier.setUse(Identifier.IdentifierUse.USUAL);
        identifier.setSystem(FhirCommon.addUrnOid((String)oidLocalId));
        identifier.setValue(testPatient.localId);
        patient.getIdentifier().add(identifier);
        patient.setBirthDate(DateUtil.parseDateyyyyMMdd2((String)testPatient.birthDate));
        patient.getAddress().add(address);
        patient.setGender(Enumerations.AdministrativeGender.valueOf((String)testPatient.gender.toUpperCase()));
        return patient;
    }

    public static TestPatient getTestPatientMueller() {
        TestPatient testPatient = new TestPatient();
        testPatient.family = "M\u00fcller";
        testPatient.given = "Franz";
        testPatient.birthDate = "1967-10-02";
        testPatient.addrLine1 = "Leidensweg 10";
        testPatient.addrState = "ZH";
        testPatient.addrPostalCode = "9876";
        testPatient.addrCountry = CountryCode.SWITZERLAND.getCodeAlpha3();
        testPatient.addrCity = "Musterhausen";
        testPatient.addrUse = "home";
        testPatient.gender = "male";
        testPatient.idInsuranceCard = "8077560000000000000000";
        testPatient.localId = "121212";
        return testPatient;
    }

    public static TestPatient getTestPatientMuellerObsolete() {
        TestPatient testPatient = new TestPatient();
        testPatient.family = "M\u00fcller";
        testPatient.given = "Franz";
        testPatient.birthDate = "1967-10-02";
        testPatient.addrLine1 = "Leidensweg 10";
        testPatient.addrState = "ZH";
        testPatient.addrPostalCode = "9876";
        testPatient.addrCountry = CountryCode.SWITZERLAND.getCodeAlpha3();
        testPatient.addrCity = "Musterhausen";
        testPatient.addrUse = "home";
        testPatient.gender = "male";
        testPatient.idInsuranceCard = "8077560000000000000000";
        testPatient.localId = "1212";
        return testPatient;
    }

    public static TestPatient getTestPatientMuellerPauline() {
        TestPatient testPatient = new TestPatient();
        testPatient.family = "M\u00fcller";
        testPatient.given = "Pauline";
        testPatient.birthDate = "1971-02-28";
        testPatient.addrLine1 = "Leidensweg 10";
        testPatient.addrState = "ZH";
        testPatient.addrPostalCode = "9876";
        testPatient.addrCountry = CountryCode.SWITZERLAND.getCodeAlpha3();
        testPatient.addrCity = "Musterhausen";
        testPatient.addrUse = "home";
        testPatient.gender = "female";
        testPatient.idInsuranceCard = "8097560000000000000000";
        testPatient.localId = "121215";
        return testPatient;
    }

    public Date getBirthDate() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return sdf.parse(this.birthDate);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

