/*
 * Decompiled with CFR 0.152.
 */
package org.husky.communication.testhelper;

import java.util.HashMap;
import java.util.Map;
import org.husky.common.enums.CodeSystems;
import org.husky.common.enums.LanguageCode;
import org.husky.common.enums.ValueSetEnumInterface;

public enum PurposeOfUse implements ValueSetEnumInterface
{
    AUTOMATIC_UPLOAD("AUTO", "2.16.756.5.30.1.127.3.10.5", "Automatic Upload", "Automatic Upload", "Automatischer Upload", "Upload automatique", "Upload automatico"),
    EMERGENCY_ACCESS("EMER", "2.16.756.5.30.1.127.3.10.5", "Emergency Access", "Emergency Access", "Notfallzugriff", "Acc\u00e8s d\u2019urgence", "Accesso di emergenza"),
    NORMAL_ACCESS("NORM", "2.16.756.5.30.1.127.3.10.5", "Normal Access", "Normal Access", "Normaler Zugriff", "Acc\u00e8s normal", "Accesso normale");

    public static final String AUTOMATIC_UPLOAD_CODE = "AUTO";
    public static final String EMERGENCY_ACCESS_CODE = "EMER";
    public static final String NORMAL_ACCESS_CODE = "NORM";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.127.3.10.15.2";
    public static final String VALUE_SET_NAME = "EprPurposeOfUse";
    private String code;
    private String codeSystem;
    private Map<LanguageCode, String> displayNames;

    public static PurposeOfUse getEnum(String code) {
        for (PurposeOfUse x : PurposeOfUse.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(PurposeOfUse.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(String codeValue) {
        for (PurposeOfUse x : PurposeOfUse.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private PurposeOfUse(String code, String codeSystem, String displayName, String displayNameEn, String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = code;
        this.codeSystem = codeSystem;
        this.displayNames = new HashMap<LanguageCode, String>();
        this.displayNames.put(null, displayName);
        this.displayNames.put(LanguageCode.ENGLISH, displayNameEn);
        this.displayNames.put(LanguageCode.GERMAN, displayNameDe);
        this.displayNames.put(LanguageCode.FRENCH, displayNameFr);
        this.displayNames.put(LanguageCode.ITALIAN, displayNameIt);
    }

    public String getCodeSystemId() {
        return this.codeSystem;
    }

    public String getCodeSystemName() {
        CodeSystems cs = CodeSystems.getEnum((String)this.codeSystem);
        if (cs != null) {
            return cs.getCodeSystemName();
        }
        return "";
    }

    public String getCodeValue() {
        return this.code;
    }

    public String getDisplayName(LanguageCode languageCode) {
        String displayName = this.displayNames.get(languageCode);
        if (displayName == null && languageCode == LanguageCode.ENGLISH) {
            return this.displayNames.get(null);
        }
        return displayName;
    }

    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

