/*
 * Decompiled with CFR 0.152.
 */
package org.husky.communication.integration;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.codesystems.V3MaritalStatus;
import org.husky.common.communication.AffinityDomain;
import org.husky.common.communication.Destination;
import org.husky.common.enums.CountryCode;
import org.husky.common.utils.DateUtil;
import org.husky.communication.ConvenienceMasterPatientIndexV3;
import org.husky.communication.mpi.impl.PixV3Query;
import org.husky.communication.testhelper.TestApplication;
import org.husky.fhir.structures.gen.FhirCommon;
import org.husky.fhir.structures.gen.FhirPatient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.NONE, classes={TestApplication.class})
@EnableAutoConfiguration
class PixV3QueryTest {
    protected static Logger log = LoggerFactory.getLogger(PixV3QueryTest.class);
    @Autowired
    private ConvenienceMasterPatientIndexV3 convenienceMasterPatientIndexV3Client;
    @Autowired
    protected AuditContext auditContext;
    private final String pixUri = "https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PIXManager_Service/PIXManager_PortType";
    private final String facilityName;
    private final String receiverApplicationOid = "1.3.6.1.4.1.12559.11.20.1.10";
    private final String senderApplicationOid = "1.2.3.4";
    private final String homeCommunityOid = "1.3.6.1.4.1.12559.11.20.1";
    private final String homeCommunityNamespace = "CHPAM2";
    private final String spidEprOid = "2.16.756.5.30.1.127.3.10.3";
    private final String spidEprNamespace = "SPID";

    PixV3QueryTest() {
        this.facilityName = null;
    }

    private Organization getScopingOrganization() {
        Organization org = new Organization();
        Identifier identifier = new Identifier();
        identifier.setValue("Husky");
        identifier.setSystem(FhirCommon.addUrnOid((String)"1.3.6.1.4.1.12559.11.20.1"));
        org.getIdentifier().add(identifier);
        return org;
    }

    @BeforeEach
    public void setUp() throws Exception {
        SpringApplication app = new SpringApplication(new Class[]{TestApplication.class});
        app.setWebApplicationType(WebApplicationType.NONE);
        app.run(new String[0]);
    }

    @Test
    void contextLoads() {
        Assertions.assertNotNull((Object)this.convenienceMasterPatientIndexV3Client);
        Assertions.assertNotNull((Object)this.convenienceMasterPatientIndexV3Client.getContext());
        Assertions.assertNotNull((Object)this.auditContext);
    }

    @Test
    void ITI44SourceFeedTest() {
        log.debug("ITI44SourceFeedTest with target https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PIXManager_Service/PIXManager_PortType");
        AffinityDomain affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        dest.setUri(URI.create("https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PIXManager_Service/PIXManager_PortType"));
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("1.3.6.1.4.1.12559.11.20.1.10");
        dest.setReceiverFacilityOid(this.facilityName);
        affinityDomain.setPdqDestination(dest);
        affinityDomain.setPixDestination(dest);
        PixV3Query pixV3Query = new PixV3Query(affinityDomain, "1.3.6.1.4.1.12559.11.20.1", "CHPAM2", "2.16.756.5.30.1.127.3.10.3", "SPID", this.convenienceMasterPatientIndexV3Client.getContext(), this.convenienceMasterPatientIndexV3Client.getAuditContext());
        FhirPatient patient = new FhirPatient();
        Identifier identifier = new Identifier();
        identifier.setValue(String.valueOf(System.currentTimeMillis()));
        identifier.setSystem(FhirCommon.addUrnOid((String)"1.3.6.1.4.1.12559.11.20.1"));
        patient.getIdentifier().add(identifier);
        Identifier identifier2 = new Identifier();
        identifier2.setValue(String.valueOf(System.currentTimeMillis()));
        identifier2.setSystem("2.16.756.5.30.1.127.3.10.3");
        patient.getIdentifier().add(identifier2);
        HumanName humanName = new HumanName().setFamily("Anders").addGiven("Miriam").addGiven("Maria").addPrefix("Dr.").addSuffix("Msc.").setUse(HumanName.NameUse.OFFICIAL);
        patient.getName().add(humanName);
        try {
            patient.setBirthDate(new SimpleDateFormat("dd.MM.yyyy").parse("24.03.1950"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        patient.setGender(Enumerations.AdministrativeGender.OTHER);
        HumanName mothersMaidenName = new HumanName();
        mothersMaidenName.setFamily("M\u00fcller");
        patient.setMothersMaidenName(mothersMaidenName);
        Address address = new Address().addLine("Testgasse 1").setPostalCode("8010").setCity("Graz").setState("Steiermark").addLine("Eingang 2, T\u00fcr 34");
        address.setCountry("AUT");
        patient.getAddress().add(address);
        CodeableConcept nation = new CodeableConcept();
        nation.setText(CountryCode.AUSTRIA.getCodeAlpha3());
        patient.setNation(nation);
        CodeableConcept religion = new CodeableConcept();
        religion.setText("Agnostic");
        patient.setReligiousAffiliation(religion);
        CodeableConcept maritalStatus = new CodeableConcept();
        maritalStatus.addCoding(new Coding(null, V3MaritalStatus.S.toCode(), V3MaritalStatus.S.getDisplay()));
        patient.setMaritalStatus(maritalStatus);
        CodeableConcept deAT = new CodeableConcept();
        deAT.setText("de-AT");
        CodeableConcept en = new CodeableConcept();
        en.setText("en");
        patient.getCommunication().add(new Patient.PatientCommunicationComponent().setLanguage(deAT));
        patient.getCommunication().add(new Patient.PatientCommunicationComponent().setLanguage(en));
        ContactPoint telHome = new ContactPoint();
        telHome.setUse(ContactPoint.ContactPointUse.HOME);
        telHome.setSystem(ContactPoint.ContactPointSystem.PHONE);
        telHome.setValue("+431000000000");
        ContactPoint telWork = new ContactPoint();
        telWork.setUse(ContactPoint.ContactPointUse.WORK);
        telWork.setSystem(ContactPoint.ContactPointSystem.PHONE);
        telWork.setValue("+431000000000");
        ContactPoint telMobile = new ContactPoint();
        telMobile.setUse(ContactPoint.ContactPointUse.MOBILE);
        telMobile.setSystem(ContactPoint.ContactPointSystem.PHONE);
        telMobile.setValue("+4366400000000");
        ContactPoint eMail = new ContactPoint();
        eMail.setUse(ContactPoint.ContactPointUse.WORK);
        eMail.setSystem(ContactPoint.ContactPointSystem.EMAIL);
        eMail.setValue("xyz@abc.at");
        patient.getTelecom().add(telHome);
        patient.getTelecom().add(telWork);
        patient.getTelecom().add(telMobile);
        patient.getTelecom().add(eMail);
        CodeableConcept employeeOccupationCode = new CodeableConcept();
        employeeOccupationCode.setText("employeeOccupationCode");
        patient.setEmployeeOccupation(employeeOccupationCode);
        patient.getManagingOrganization().setResource((IBaseResource)this.getScopingOrganization());
        FhirContext ctx = new FhirContext(FhirVersionEnum.R4);
        String encoded = ctx.newXmlParser().encodeResourceToString((IBaseResource)patient);
        log.debug(encoded);
        Assertions.assertTrue((boolean)pixV3Query.addPatient(patient, null, null));
    }

    @Test
    void ITI44SourceMergeTest() {
        log.debug("ITI44SourceMergeTest with target {}", (Object)"https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PIXManager_Service/PIXManager_PortType");
        AffinityDomain affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        dest.setUri(URI.create("https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PIXManager_Service/PIXManager_PortType"));
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("1.3.6.1.4.1.12559.11.20.1.10");
        dest.setReceiverFacilityOid(this.facilityName);
        affinityDomain.setPdqDestination(dest);
        affinityDomain.setPixDestination(dest);
        PixV3Query pixV3Query = new PixV3Query(affinityDomain, "1.3.6.1.4.1.12559.11.20.1", "CHPAM2", null, null, this.convenienceMasterPatientIndexV3Client.getContext(), this.convenienceMasterPatientIndexV3Client.getAuditContext());
        FhirPatient patient = new FhirPatient();
        HumanName humanName = new HumanName().setFamily("Maier").addGiven("Hubert");
        patient.getName().add(humanName);
        Identifier identifier = new Identifier();
        identifier.setValue("1634641399206");
        identifier.setSystem(FhirCommon.addUrnOid((String)"1.3.6.1.4.1.12559.11.20.1"));
        patient.getIdentifier().add(identifier);
        Identifier identifier2 = new Identifier();
        identifier2.setValue("SPID-1");
        identifier2.setSystem("2.16.756.5.30.1.127.3.10.3");
        patient.getIdentifier().add(identifier2);
        patient.setBirthDate(DateUtil.parseDateyyyyMMdd((String)"19500324"));
        patient.setGender(Enumerations.AdministrativeGender.MALE);
        patient.getManagingOrganization().setResource((IBaseResource)this.getScopingOrganization());
        FhirContext ctx = new FhirContext(FhirVersionEnum.R4);
        String encoded = ctx.newXmlParser().encodeResourceToString((IBaseResource)patient);
        log.debug(encoded);
        Assertions.assertTrue((boolean)pixV3Query.mergePatient(patient, "1634721569120", null, null));
    }

    @Test
    void ITI44SourceUpdateTest() {
        AffinityDomain affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        dest.setUri(URI.create("https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PIXManager_Service/PIXManager_PortType"));
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("1.3.6.1.4.1.12559.11.20.1.10");
        dest.setReceiverFacilityOid(this.facilityName);
        affinityDomain.setPdqDestination(dest);
        affinityDomain.setPixDestination(dest);
        PixV3Query pixV3Query = new PixV3Query(affinityDomain, "1.3.6.1.4.1.12559.11.20.1", "CHPAM2", null, null, this.convenienceMasterPatientIndexV3Client.getContext(), this.convenienceMasterPatientIndexV3Client.getAuditContext());
        FhirPatient patient = new FhirPatient();
        HumanName humanName = new HumanName().setFamily("Bauer-Maier").addGiven("Anton");
        patient.getName().add(humanName);
        Address address = new Address().addLine("Testgasse 18").setPostalCode("1020").setCity("Wien").setState("AUT");
        Identifier identifier = new Identifier();
        identifier.setValue("1634793774730");
        identifier.setSystem(FhirCommon.addUrnOid((String)"1.3.6.1.4.1.12559.11.20.1"));
        patient.getIdentifier().add(identifier);
        Identifier identifier2 = new Identifier();
        identifier2.setValue("SPID-101");
        identifier2.setSystem("2.16.756.5.30.1.127.3.10.3");
        patient.getIdentifier().add(identifier2);
        patient.setBirthDate(DateUtil.parseDateyyyyMMdd((String)"19500324"));
        patient.getAddress().add(address);
        patient.setGender(Enumerations.AdministrativeGender.MALE);
        patient.getManagingOrganization().setResource((IBaseResource)this.getScopingOrganization());
        FhirContext ctx = new FhirContext(FhirVersionEnum.R4);
        String encoded = ctx.newXmlParser().encodeResourceToString((IBaseResource)patient);
        log.debug(encoded);
        Assertions.assertTrue((boolean)pixV3Query.updatePatient(patient, null, null));
    }

    @Test
    void ITI45ConsumerTest() {
        log.debug("ITI45ConsumerTest with target https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PIXManager_Service/PIXManager_PortType");
        AffinityDomain affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        dest.setUri(URI.create("https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PIXManager_Service/PIXManager_PortType"));
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("1.3.6.1.4.1.12559.11.20.1.10");
        dest.setReceiverFacilityOid(this.facilityName);
        affinityDomain.setPdqDestination(dest);
        affinityDomain.setPixDestination(dest);
        PixV3Query pixV3Query = new PixV3Query(affinityDomain, "1.3.6.1.4.1.12559.11.20.1", "CHPAM2", "2.16.756.5.30.1.127.3.10.3", "SPID", this.convenienceMasterPatientIndexV3Client.getContext(), this.convenienceMasterPatientIndexV3Client.getAuditContext());
        FhirPatient patient = new FhirPatient();
        Identifier identifier = new Identifier();
        identifier.setValue("CHPAM4489");
        identifier.setSystem(FhirCommon.addUrnOid((String)"1.3.6.1.4.1.12559.11.20.1"));
        patient.getIdentifier().add(identifier);
        String patId = pixV3Query.queryPatientId(patient, null, null);
        Assertions.assertEquals((Object)"761337610436974489", (Object)patId);
    }
}

