/*
 * Decompiled with CFR 0.152.
 */
package org.husky.communication.integration;

import java.io.InputStream;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import net.ihe.gazelle.hl7v3.prpain201306UV02.PRPAIN201306UV02Type;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.StringType;
import org.husky.common.basetypes.AddressBaseType;
import org.husky.common.communication.AffinityDomain;
import org.husky.common.communication.Destination;
import org.husky.common.enums.AdministrativeGender;
import org.husky.common.model.Address;
import org.husky.common.model.Identificator;
import org.husky.common.model.Name;
import org.husky.common.model.Patient;
import org.husky.communication.ConvenienceMasterPatientIndexV3;
import org.husky.communication.MasterPatientIndexQuery;
import org.husky.communication.MasterPatientIndexQueryResponse;
import org.husky.communication.mpi.impl.PdqV3Query;
import org.husky.communication.mpi.impl.pdq.V3PdqConsumerResponse;
import org.husky.communication.testhelper.TestApplication;
import org.husky.fhir.structures.gen.FhirCommon;
import org.husky.fhir.structures.gen.FhirPatient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.NONE, classes={TestApplication.class})
@EnableAutoConfiguration
class PdqV3QueryTest {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PdqV3QueryTest.class.getName());
    @Autowired
    private ConvenienceMasterPatientIndexV3 convenienceMasterPatientIndexV3Client;
    private final String pdqUri = "https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PDQSupplier_Service/PDQSupplier_PortType";
    private final String applicationName = "2.16.840.1.113883.3.72.6.5.100.1399";
    private final String facilityName;
    private final String senderApplicationOid = "1.2.3.4";

    PdqV3QueryTest() {
        this.facilityName = null;
    }

    private V3PdqConsumerResponse loadV3PdqResponse() throws Exception {
        try (InputStream inputStream = this.getClass().getResourceAsStream("/02_PDQQuery1Response.xml");){
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{PRPAIN201306UV02Type.class}).createUnmarshaller();
            PRPAIN201306UV02Type rootElement = (PRPAIN201306UV02Type)unmarshaller.unmarshal(inputStream);
            V3PdqConsumerResponse v3PdqConsumerResponse = new V3PdqConsumerResponse(rootElement);
            return v3PdqConsumerResponse;
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        SpringApplication app = new SpringApplication(new Class[]{TestApplication.class});
        app.setWebApplicationType(WebApplicationType.NONE);
        app.run(new String[0]);
    }

    @Test
    void contextLoads() {
        Assertions.assertNotNull((Object)this.convenienceMasterPatientIndexV3Client);
        Assertions.assertNotNull((Object)this.convenienceMasterPatientIndexV3Client.getContext());
    }

    @Test
    void testGetPatientsFromPdqQuery() throws Exception {
        AffinityDomain affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        dest.setUri(URI.create("https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PDQSupplier_Service/PDQSupplier_PortType"));
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("2.16.840.1.113883.3.72.6.5.100.1399");
        dest.setReceiverFacilityOid(this.facilityName);
        affinityDomain.setPdqDestination(dest);
        affinityDomain.setPixDestination(dest);
        V3PdqConsumerResponse response = this.loadV3PdqResponse();
        Assertions.assertNotNull((Object)response);
        PdqV3Query v3PdqQuery = new PdqV3Query(affinityDomain, null, null, this.convenienceMasterPatientIndexV3Client.getAuditContext());
        List patients = v3PdqQuery.getPatientsFromPdqQuery(response);
        Assertions.assertEquals((int)2, (int)patients.size());
        FhirPatient james = (FhirPatient)patients.get(0);
        Assertions.assertEquals((Object)"Jones", (Object)james.getNameFirstRep().getFamily());
        Assertions.assertEquals((Object)"James", (Object)james.getNameFirstRep().getGivenAsSingleString());
        Assertions.assertEquals((Object)"work", (Object)((ContactPoint)james.getTelecom().get(0)).getUse().toCode().toLowerCase());
        Assertions.assertEquals((Object)"+1-481-555-7684;ext=2342", (Object)((ContactPoint)james.getTelecom().get(0)).getValue());
        Assertions.assertEquals((Object)"home", (Object)((ContactPoint)james.getTelecom().get(1)).getUse().toCode().toLowerCase());
        Assertions.assertEquals((Object)"+1-765-555-4352", (Object)((ContactPoint)james.getTelecom().get(1)).getValue());
        Assertions.assertEquals((Object)"male", (Object)james.getGender().toCode().toLowerCase());
        Assertions.assertEquals((Object)"1963-08-04", (Object)james.getBirthDateElement().getValueAsString());
        Assertions.assertEquals((Object)"3443 North Arctic Avenue", (Object)((StringType)james.getAddressFirstRep().getLine().get(0)).getValue());
        Assertions.assertEquals((Object)"Some City", (Object)james.getAddressFirstRep().getCity());
        Assertions.assertEquals((Object)"IL", (Object)james.getAddressFirstRep().getState());
        Assertions.assertEquals((Object)FhirCommon.addUrnOid((String)"1.2.840.114350.1.13.99998.8734"), (Object)james.getIdentifierFirstRep().getSystem());
        Assertions.assertEquals((Object)"34827K410", (Object)james.getIdentifierFirstRep().getValue());
        Assertions.assertEquals((Object)FhirCommon.addUrnOid((String)"1.2.840.114350.1.13.99997.2.3412"), (Object)((Identifier)james.getIdentifier().get(1)).getSystem());
        Assertions.assertEquals((Object)"38273D433", (Object)((Identifier)james.getIdentifier().get(1)).getValue());
        Assertions.assertEquals((Object)FhirCommon.addUrnOid((String)"2.16.840.1.113883.4.1"), (Object)((Identifier)james.getIdentifier().get(2)).getSystem());
        Assertions.assertEquals((Object)"999-88-6345", (Object)((Identifier)james.getIdentifier().get(2)).getValue());
        Assertions.assertNotNull((Object)james.getManagingOrganization().getResource());
        Organization organization = (Organization)james.getManagingOrganization().getResource();
        Assertions.assertEquals((Object)FhirCommon.addUrnOid((String)"1.2.840.114350.1.13.99998.8734"), (Object)((Identifier)organization.getIdentifier().get(0)).getValue());
        Assertions.assertEquals((Object)"Good Health Clinic", (Object)organization.getName());
        Assertions.assertEquals((Object)"+1-342-555-8394", (Object)organization.getTelecomFirstRep().getValue());
        this.testSecondPatient((FhirPatient)patients.get(1));
    }

    private void testSecondPatient(FhirPatient jim) {
        Assertions.assertEquals((Object)"Jones", (Object)jim.getNameFirstRep().getFamily());
        Assertions.assertEquals((Object)"Jim", (Object)jim.getNameFirstRep().getGivenAsSingleString());
        Assertions.assertEquals((Object)"home", (Object)((ContactPoint)jim.getTelecom().get(0)).getUse().toCode().toLowerCase());
        Assertions.assertEquals((Object)"+1-795-555-4745", (Object)((ContactPoint)jim.getTelecom().get(0)).getValue());
        Assertions.assertEquals((Object)"1963-07-13", (Object)jim.getBirthDateElement().getValueAsString());
        Assertions.assertEquals((Object)"8734 Blue Ocean Street", (Object)((StringType)jim.getAddressFirstRep().getLine().get(0)).getValue());
        Assertions.assertEquals((Object)"Other City", (Object)jim.getAddressFirstRep().getCity());
        Assertions.assertEquals((Object)"IL", (Object)jim.getAddressFirstRep().getState());
        Organization organization = (Organization)jim.getManagingOrganization().getResource();
        Assertions.assertEquals((Object)FhirCommon.addUrnOid((String)"1.2.840.114350.1.13.99998.8734"), (Object)((Identifier)organization.getIdentifier().get(0)).getValue());
        Assertions.assertEquals((Object)"Good Health Clinic", (Object)organization.getName());
        Assertions.assertEquals((Object)"+1-342-555-8394", (Object)organization.getTelecomFirstRep().getValue());
        Assertions.assertEquals((Object)FhirCommon.addUrnOid((String)"1.2.840.114350.1.13.99998.8734"), (Object)jim.getIdentifierFirstRep().getSystem());
        Assertions.assertEquals((Object)"34827R534", (Object)jim.getIdentifierFirstRep().getValue());
    }

    @Test
    void ITI47ConsumerQueryPatientPatientIdNotFoundTest() {
        AffinityDomain affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        dest.setUri(URI.create("https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PDQSupplier_Service/PDQSupplier_PortType"));
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("2.16.840.1.113883.3.72.6.5.100.1399");
        dest.setReceiverFacilityOid(this.facilityName);
        affinityDomain.setPdqDestination(dest);
        affinityDomain.setPixDestination(dest);
        LOGGER.debug("ITI47ConsumerQueryPatientPatientIdNotFoundTest with ipAdress Target https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PDQSupplier_Service/PDQSupplier_PortType");
        MasterPatientIndexQuery mpiQuery = new MasterPatientIndexQuery(affinityDomain.getPdqDestination());
        Identificator identificator = new Identificator("1.3.6.1.4.1.12559.11.20.1", "4711");
        mpiQuery.addPatientIdentificator(identificator);
        MasterPatientIndexQueryResponse response = this.convenienceMasterPatientIndexV3Client.queryPatientDemographics(mpiQuery, affinityDomain, null, null);
        Assertions.assertTrue((boolean)response.getSuccess());
        Assertions.assertEquals((int)0, (int)response.getTotalNumbers());
    }

    @Test
    void ITI47ConsumerQueryPatientPatientIdFoundTest() {
        AffinityDomain affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        dest.setUri(URI.create("https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PDQSupplier_Service/PDQSupplier_PortType"));
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("2.16.840.1.113883.3.72.6.5.100.1399");
        dest.setReceiverFacilityOid(this.facilityName);
        affinityDomain.setPdqDestination(dest);
        affinityDomain.setPixDestination(dest);
        LOGGER.debug("ITI47ConsumerQueryPatientPatientIdFoundTest with ipAdress Target https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PDQSupplier_Service/PDQSupplier_PortType");
        MasterPatientIndexQuery mpiQuery2 = new MasterPatientIndexQuery(affinityDomain.getPdqDestination());
        Identificator identificator2 = new Identificator("1.3.6.1.4.1.12559.11.20.1", "CHPAM18");
        mpiQuery2.addPatientIdentificator(identificator2);
        MasterPatientIndexQueryResponse response2 = this.convenienceMasterPatientIndexV3Client.queryPatientDemographics(mpiQuery2, affinityDomain, null, null);
        List patients = response2.getPatients();
        Assertions.assertTrue((boolean)response2.getSuccess());
        Assertions.assertEquals((int)1, (int)patients.size());
        Patient patient = (Patient)patients.get(0);
        Assertions.assertEquals((Object)"Jasmin Schaub", (Object)patient.getCompleteName().trim());
        Assertions.assertEquals((Object)patient.getAdministrativeGenderCode().getCodeValue(), (Object)AdministrativeGender.FEMALE.getCodeValue());
        Assertions.assertEquals((Object)"CHE", (Object)patient.getAddress().getCountry());
    }

    @Test
    void ITI47ConsumerQueryPatientPatientIdSearchByName() {
        AffinityDomain affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        dest.setUri(URI.create("https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PDQSupplier_Service/PDQSupplier_PortType"));
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("2.16.840.1.113883.3.72.6.5.100.1399");
        dest.setReceiverFacilityOid(this.facilityName);
        affinityDomain.setPdqDestination(dest);
        affinityDomain.setPixDestination(dest);
        LOGGER.debug("ITI47ConsumerQueryPatientPatientIdSearchByName with ipAdress Target https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PDQSupplier_Service/PDQSupplier_PortType");
        MasterPatientIndexQuery mpiQuery = new MasterPatientIndexQuery(affinityDomain.getPdqDestination());
        Name patientName = new Name();
        patientName.setFamily("Sanders");
        mpiQuery.addPatientName(false, patientName);
        MasterPatientIndexQueryResponse response = this.convenienceMasterPatientIndexV3Client.queryPatientDemographics(mpiQuery, affinityDomain, null, null);
        Assertions.assertTrue((boolean)response.getSuccess());
        Assertions.assertTrue((response.getPatients().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    void ITI47ConsumerQueryPatientPatientIdMultipleCriteria() {
        AffinityDomain affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        dest.setUri(URI.create("https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PDQSupplier_Service/PDQSupplier_PortType"));
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("2.16.840.1.113883.3.72.6.5.100.1399");
        dest.setReceiverFacilityOid(this.facilityName);
        affinityDomain.setPdqDestination(dest);
        affinityDomain.setPixDestination(dest);
        LOGGER.debug("ITI47ConsumerQueryPatientPatientIdSearchByName with ipAdress Target https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PDQSupplier_Service/PDQSupplier_PortType");
        MasterPatientIndexQuery mpiQuery = new MasterPatientIndexQuery(affinityDomain.getPdqDestination());
        try {
            mpiQuery.setPatientDateOfBirth(new SimpleDateFormat("dd.MM.yyyy").parse("22.06.1958"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Name patientName = new Name();
        patientName.setGiven("David");
        mpiQuery.addPatientName(false, patientName);
        Address address = new Address(new AddressBaseType());
        address.setCity("Acworth");
        address.setPostalCode("30101");
        address.setStreetName("Southside Drive");
        mpiQuery.addPatientAddress(address);
        MasterPatientIndexQueryResponse response = this.convenienceMasterPatientIndexV3Client.queryPatientDemographics(mpiQuery, affinityDomain, null, null);
        Assertions.assertTrue((boolean)response.getSuccess());
        Assertions.assertEquals((int)1, (int)response.getPatients().size());
        Patient patient = (Patient)response.getPatients().get(0);
        Assertions.assertEquals((Object)"David Sanders", (Object)patient.getCompleteName().trim());
        Assertions.assertEquals((Object)AdministrativeGender.MALE.getCodeValue(), (Object)patient.getAdministrativeGenderCode().getCodeValue());
    }
}

