/*
 * Decompiled with CFR 0.152.
 */
package org.husky.communication.integration;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.GregorianCalendar;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.husky.common.communication.AffinityDomain;
import org.husky.common.communication.Destination;
import org.husky.common.model.Identificator;
import org.husky.communication.ConvenienceMasterPatientIndexV3;
import org.husky.communication.MasterPatientIndexQuery;
import org.husky.communication.MasterPatientIndexQueryResponse;
import org.husky.communication.mpi.impl.PixV3Query;
import org.husky.communication.testhelper.TestApplication;
import org.husky.fhir.structures.gen.FhirCommon;
import org.husky.fhir.structures.gen.FhirPatient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.NONE, classes={TestApplication.class})
@EnableAutoConfiguration
@ActiveProfiles(value={"atna"})
class ConvenienceMasterPatientIndexV3AtnaAuditTest {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ConvenienceMasterPatientIndexV3AtnaAuditTest.class.getName());
    @Autowired
    private ConvenienceMasterPatientIndexV3 convenienceMasterPatientIndexV3Client;
    private final String pdqUri = "https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PDQSupplier_Service/PDQSupplier_PortType";
    private final String pixUri = "https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PIXManager_Service/PIXManager_PortType";
    private final String applicationName = "2.16.840.1.113883.3.72.6.5.100.1399";
    private final String facilityName;
    private final String senderApplicationOid = "1.2.3.4";
    private final String receiverApplicationOid = "1.3.6.1.4.1.12559.11.20.1.10";
    private final String homeCommunityOid = "1.3.6.1.4.1.12559.11.20.1";
    private final String homeCommunityNamespace = "CHPAM2";
    private final String spidEprOid = "2.16.756.5.30.1.127.3.10.3";
    private final String spidEprNamespace = "SPID";

    ConvenienceMasterPatientIndexV3AtnaAuditTest() {
        this.facilityName = null;
    }

    private Organization getScopingOrganization() {
        Organization org = new Organization();
        Identifier identifier = new Identifier();
        identifier.setValue("Husky");
        identifier.setSystem(FhirCommon.addUrnOid((String)"1.3.6.1.4.1.12559.11.20.1"));
        org.getIdentifier().add(identifier);
        return org;
    }

    @Test
    void queryPatientDemographicsWithAtnaAuditMessageTest() throws Exception {
        LOGGER.debug("ITI47ConsumerQueryPatientPatientIdStep1Test with ipAdress Target https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PDQSupplier_Service/PDQSupplier_PortType");
        AffinityDomain affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        try {
            dest.setUri(new URI("https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PDQSupplier_Service/PDQSupplier_PortType"));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("2.16.840.1.113883.3.72.6.5.100.1399");
        dest.setReceiverFacilityOid(this.facilityName);
        affinityDomain.setPdqDestination(dest);
        affinityDomain.setPixDestination(dest);
        MasterPatientIndexQuery mpiQuery = new MasterPatientIndexQuery(affinityDomain.getPdqDestination());
        Identificator identificator = new Identificator("1.3.6.1.4.1.12559.11.20.1", "4711");
        mpiQuery.addPatientIdentificator(identificator);
        MasterPatientIndexQueryResponse response = this.convenienceMasterPatientIndexV3Client.queryPatientDemographics(mpiQuery, affinityDomain, null, null);
        Assertions.assertTrue((boolean)response.getSuccess());
        String logContent = this.checkAuditLogging();
        Assertions.assertTrue((boolean)logContent.contains("<EventID csd-code=\"110112\""));
        Assertions.assertTrue((boolean)logContent.contains("<EventTypeCode csd-code=\"ITI-47\""));
        Assertions.assertTrue((boolean)logContent.contains("RoleIDCode csd-code=\"110153\""));
        Assertions.assertTrue((boolean)logContent.contains("RoleIDCode csd-code=\"110152\""));
    }

    @Test
    void updatePatientTest() throws IOException {
        AffinityDomain affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        dest.setUri(URI.create("https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PIXManager_Service/PIXManager_PortType"));
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("1.3.6.1.4.1.12559.11.20.1.10");
        dest.setReceiverFacilityOid(this.facilityName);
        affinityDomain.setPdqDestination(dest);
        affinityDomain.setPixDestination(dest);
        PixV3Query pixV3Query = new PixV3Query(affinityDomain, "1.3.6.1.4.1.12559.11.20.1", "CHPAM2", null, null, this.convenienceMasterPatientIndexV3Client.getContext(), this.convenienceMasterPatientIndexV3Client.getAuditContext());
        FhirPatient patient = new FhirPatient();
        HumanName humanName = new HumanName().setFamily("Bauer-Maier").addGiven("Anton");
        patient.getName().add(humanName);
        Address address = new Address().addLine("Testgasse 18").setPostalCode("1020").setCity("Wien").setState("AUT");
        Identifier identifier = new Identifier();
        identifier.setValue("1634793774730");
        identifier.setSystem(FhirCommon.addUrnOid((String)"1.3.6.1.4.1.12559.11.20.1"));
        patient.getIdentifier().add(identifier);
        Identifier identifier2 = new Identifier();
        identifier2.setValue("SPID-101");
        identifier2.setSystem("2.16.756.5.30.1.127.3.10.3");
        patient.getIdentifier().add(identifier2);
        patient.setBirthDate(new GregorianCalendar(1950, 2, 24).getTime());
        patient.getAddress().add(address);
        patient.setGender(Enumerations.AdministrativeGender.MALE);
        patient.getManagingOrganization().setResource((IBaseResource)this.getScopingOrganization());
        FhirContext ctx = new FhirContext(FhirVersionEnum.R4);
        String encoded = ctx.newXmlParser().encodeResourceToString((IBaseResource)patient);
        LOGGER.debug(encoded);
        Assertions.assertTrue((boolean)pixV3Query.updatePatient(patient, null, null));
        String logContent = this.checkAuditLogging();
        Assertions.assertTrue((boolean)logContent.contains("<EventID csd-code=\"110110\""));
        Assertions.assertTrue((boolean)logContent.contains("<EventTypeCode csd-code=\"ITI-44\""));
        Assertions.assertTrue((boolean)logContent.contains("RoleIDCode csd-code=\"110153\""));
        Assertions.assertTrue((boolean)logContent.contains("RoleIDCode csd-code=\"110152\""));
    }

    @Test
    void queryPatientIdTest() throws IOException {
        AffinityDomain affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        dest.setUri(URI.create("https://ehealthsuisse.ihe-europe.net/PAMSimulator-ejb/PIXManager_Service/PIXManager_PortType"));
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("1.3.6.1.4.1.12559.11.20.1.10");
        dest.setReceiverFacilityOid(this.facilityName);
        affinityDomain.setPdqDestination(dest);
        affinityDomain.setPixDestination(dest);
        PixV3Query pixV3Query = new PixV3Query(affinityDomain, "1.3.6.1.4.1.12559.11.20.1", "CHPAM2", "2.16.756.5.30.1.127.3.10.3", "SPID", this.convenienceMasterPatientIndexV3Client.getContext(), this.convenienceMasterPatientIndexV3Client.getAuditContext());
        FhirPatient patient = new FhirPatient();
        Identifier identifier = new Identifier();
        identifier.setValue("CHPAM4489");
        identifier.setSystem(FhirCommon.addUrnOid((String)"1.3.6.1.4.1.12559.11.20.1"));
        patient.getIdentifier().add(identifier);
        String patId = pixV3Query.queryPatientId(patient, null, null);
        Assertions.assertEquals((Object)"761337610436974489", (Object)patId);
        String logContent = this.checkAuditLogging();
        Assertions.assertTrue((boolean)logContent.contains("<EventID csd-code=\"110112\""));
        Assertions.assertTrue((boolean)logContent.contains("<EventTypeCode csd-code=\"ITI-45\""));
        Assertions.assertTrue((boolean)logContent.contains("RoleIDCode csd-code=\"110153\""));
        Assertions.assertTrue((boolean)logContent.contains("RoleIDCode csd-code=\"110152\""));
    }

    private String checkAuditLogging() throws IOException {
        File originLogFile = new File("log/Spring-TestEHC.log");
        String logContent = new String(Files.readAllBytes(originLogFile.toPath()));
        Assertions.assertFalse((boolean)logContent.contains("Failed to send ATNA audit event to destination"));
        Assertions.assertTrue((boolean)logContent.contains("Auditing"));
        return logContent;
    }
}

