/*
 * Decompiled with CFR 0.152.
 */
package org.husky.communication.integration;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.husky.common.communication.DocumentMetadata;
import org.husky.common.communication.SubmissionSetMetadata;
import org.husky.common.enums.DocumentDescriptor;
import org.husky.common.model.Identificator;
import org.husky.communication.ConvenienceCommunication;
import org.husky.communication.testhelper.TestApplication;
import org.husky.communication.testhelper.XdmTestUtils;
import org.husky.communication.xd.xdm.DocumentContentAndMetadata;
import org.husky.communication.xd.xdm.XdmContents;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.NONE, classes={TestApplication.class})
@EnableAutoConfiguration
class ConvenienceCommunicationXdmContentsTest
extends XdmTestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ConvenienceCommunicationXdmContentsTest.class.getName());
    public static final String XDM_FILE_PATH = "/docConsumer/xdm.zip";
    public static final String XDM_CORRUPT_FILE_PATH = "/docConsumer/xdmCorrupt.zip";
    public static final String PDF_FILE_PATH = "/docConsumer/patientconsent.pdf";
    public static final String CDA_FILE_PATH = "/docConsumer/CDA-CH-VACD_Impfausweis.xml";
    private static final DateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    @Autowired
    private ConvenienceCommunication convenienceCommunication;
    private String filePath = ConvenienceCommunicationXdmContentsTest.getTempFilePath();

    ConvenienceCommunicationXdmContentsTest() {
    }

    @Test
    void contextLoads() {
        Assertions.assertNotNull((Object)this.convenienceCommunication);
        Assertions.assertNotNull((Object)this.convenienceCommunication.getCamelContext());
    }

    @Test
    void createXdmContentsTest() throws Exception {
        DocumentMetadata metaData = this.convenienceCommunication.addDocument(DocumentDescriptor.CDA_R2, this.getDocCda(), this.getDocCda());
        Identificator patientId = new Identificator("1.3.6.1.4.1.21367.13.20.3000", "IHEBLUE-1043");
        this.setMetadataForCda(metaData, patientId);
        metaData = this.convenienceCommunication.addDocument(DocumentDescriptor.PDF, this.getDocPdf());
        this.setMetadataForPdf(metaData, patientId);
        SubmissionSetMetadata subSet = new SubmissionSetMetadata();
        this.setSubmissionMetadata(subSet, patientId);
        File targetFile = new File("src/test/resources/xdmTest_Java.zip");
        try (FileOutputStream outputStream = new FileOutputStream(targetFile);){
            this.convenienceCommunication.createXdmContents(subSet, (OutputStream)outputStream);
        }
        this.checkZipContent(targetFile);
    }

    private void checkZipContent(File targetFile) throws Exception {
        String readmeFile = null;
        String indexHtmFile = null;
        Path iheXdmFolder = null;
        File targetUnzip = new File("src/test/resources/xdmTest_Java");
        try (ZipFile zipFile = new ZipFile(targetFile);){
            Iterator<? extends ZipEntry> entryIt = zipFile.entries().asIterator();
            while (entryIt.hasNext()) {
                ZipEntry zipEntry = entryIt.next();
                Path resolvedPath = targetUnzip.toPath().resolve(zipEntry.getName()).normalize();
                InputStream is = zipFile.getInputStream(zipEntry);
                try {
                    if ("README.TXT".equals(zipEntry.getName())) {
                        readmeFile = new String(is.readAllBytes());
                        continue;
                    }
                    if ("INDEX.HTM".equals(zipEntry.getName())) {
                        indexHtmFile = new String(is.readAllBytes());
                        continue;
                    }
                    if (!zipEntry.getName().contains("IHE_XDM/")) continue;
                    if (zipEntry.isDirectory()) {
                        if (zipEntry.getName().equals("IHE_XDM/")) {
                            iheXdmFolder = Files.createDirectories(resolvedPath, new FileAttribute[0]);
                            continue;
                        }
                        Files.createDirectories(resolvedPath, new FileAttribute[0]);
                        continue;
                    }
                    Files.createDirectories(resolvedPath.getParent(), new FileAttribute[0]);
                    Files.copy(is, resolvedPath, StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            Assertions.assertNotNull(readmeFile);
            this.testReadMeFile(readmeFile);
            Assertions.assertNotNull(indexHtmFile);
            this.testIndexHtmFile(indexHtmFile);
            Assertions.assertNotNull(iheXdmFolder);
        }
        this.checkSubsetDirContent(String.format("%s/SUBSET01", iheXdmFolder.toString()));
    }

    private void testReadMeFile(String readmeContent) {
        Assertions.assertTrue((boolean)readmeContent.contains("Husky - https://github.com/project-husky/husky"));
        Assertions.assertTrue((boolean)readmeContent.contains("Open Source"));
        Assertions.assertTrue((boolean)readmeContent.contains("Convenience API"));
        Assertions.assertTrue((boolean)readmeContent.contains("https://github.com/project-husky/husky"));
    }

    private void testIndexHtmFile(String indexHtmContent) {
        Assertions.assertTrue((boolean)indexHtmContent.contains("Husky XDM Cross-Enterprise Document Media Interchange"));
        Assertions.assertTrue((boolean)indexHtmContent.contains("Patient ID: IHEBLUE-1043 (1.3.6.1.4.1.21367.13.20.3000)"));
        Assertions.assertTrue((boolean)indexHtmContent.contains("<a target=\"_blank\" href=\"README.TXT\">"));
        Assertions.assertTrue((boolean)indexHtmContent.contains("IHE_XDM/SUBSET01/DOC00002.PDF"));
        Assertions.assertTrue((boolean)indexHtmContent.contains("IHE_XDM/SUBSET01/DOC00001.XML"));
    }

    private void checkSubsetDirContent(String dir) throws Exception {
        String metadataXml = null;
        String doc1 = null;
        String doc2 = null;
        File directory = new File(dir);
        File[] files = directory.listFiles();
        Assertions.assertNotNull((Object)files);
        for (File file : files) {
            try (FileInputStream is = new FileInputStream(file);){
                if ("METADATA.XML".equals(file.getName())) {
                    metadataXml = new String(((InputStream)is).readAllBytes());
                    continue;
                }
                if (file.getName().contains("DOC00002.PDF")) {
                    doc1 = new String(((InputStream)is).readAllBytes());
                    continue;
                }
                if (!file.getName().contains("DOC00001.XML")) continue;
                doc2 = new String(((InputStream)is).readAllBytes());
            }
        }
        Assertions.assertNotNull(metadataXml);
        this.validateMetadata(metadataXml);
        Assertions.assertNotNull(doc1);
        Assertions.assertNotNull(doc2);
    }

    private void validateMetadata(String documentContent) throws Exception {
        CloseableHttpClient httpClient = HttpClients.custom().build();
        HttpPost post = new HttpPost("https://gazelle.ihe.net/XDStarClient-ejb/ModelBasedValidationWSService/ModelBasedValidationWS");
        post.setEntity((HttpEntity)new ByteArrayEntity(this.createSOAPRequest(documentContent)));
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
        String contentResponse = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        Assertions.assertFalse((boolean)contentResponse.contains("FAILED"));
    }

    private byte[] createSOAPRequest(String documentContent) throws Exception {
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage soapMessage = messageFactory.createMessage();
        SOAPPart soapPart = soapMessage.getSOAPPart();
        SOAPEnvelope envelope = soapPart.getEnvelope();
        envelope.addNamespaceDeclaration("ws", "http://ws.mb.validator.gazelle.ihe.net");
        SOAPBody soapBody = envelope.getBody();
        SOAPElement soapBodyElem = soapBody.addChildElement("validateBase64Document", "ws");
        SOAPElement soapBodyElemBase64Doc = soapBodyElem.addChildElement("base64Document");
        soapBodyElemBase64Doc.addTextNode(Base64.getEncoder().encodeToString(documentContent.getBytes()));
        SOAPElement soapBodyElementValidator = soapBodyElem.addChildElement("validator");
        soapBodyElementValidator.addTextNode("IHE XDM ITI-32 Distribute Document Set on Media");
        soapMessage.saveChanges();
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        soapMessage.writeTo((OutputStream)byteOutput);
        return byteOutput.toByteArray();
    }

    @Test
    void exportImportTest() throws IOException {
        File targetFile = new File(this.filePath + "/xdm_" + dateFormat.format(new Date()).replace(".", "").replace(" ", "").replace(":", "") + ".zip");
        this.convenienceCommunication.clearDocuments();
        XdmContents exportContents = this.exportSamples(this.convenienceCommunication, targetFile, CDA_FILE_PATH, PDF_FILE_PATH);
        Assertions.assertNotNull((Object)exportContents);
        Assertions.assertTrue((boolean)targetFile.exists());
        XdmContents importContents = this.importSamples(this.convenienceCommunication, targetFile);
        Assertions.assertNotNull((Object)importContents);
        Assertions.assertEquals((Object)((DocumentContentAndMetadata)exportContents.getDocumentAndMetadataList().get(0)).getDocEntry(), (Object)((DocumentContentAndMetadata)importContents.getDocumentAndMetadataList().get(0)).getDocEntry());
        Assertions.assertEquals((Object)((DocumentContentAndMetadata)exportContents.getDocumentAndMetadataList().get(1)).getDocEntry(), (Object)((DocumentContentAndMetadata)importContents.getDocumentAndMetadataList().get(1)).getDocEntry());
        Assertions.assertTrue((boolean)this.isSamplesHashAndSizeEqual(importContents, CDA_FILE_PATH, PDF_FILE_PATH));
    }

    @Test
    void importIntegrityCheck() {
        this.convenienceCommunication.clearDocuments();
        Assertions.assertTrue((boolean)this.importIntegrityCheck(XDM_FILE_PATH, this.convenienceCommunication));
        Assertions.assertFalse((boolean)this.importIntegrityCheck(XDM_CORRUPT_FILE_PATH, this.convenienceCommunication));
    }
}

