/*
 * Decompiled with CFR 0.152.
 */
package org.husky.communication.integration;

import java.net.URI;
import java.net.URISyntaxException;
import org.husky.common.communication.AffinityDomain;
import org.husky.common.communication.Destination;
import org.husky.common.communication.DocumentMetadata;
import org.husky.common.communication.SubmissionSetMetadata;
import org.husky.common.enums.DocumentDescriptor;
import org.husky.common.model.Code;
import org.husky.common.model.Identificator;
import org.husky.communication.ConvenienceCommunication;
import org.husky.communication.testhelper.TestApplication;
import org.husky.communication.testhelper.XdsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Document;
import org.openehealth.ipf.commons.ihe.xds.core.responses.ErrorCode;
import org.openehealth.ipf.commons.ihe.xds.core.responses.ErrorInfo;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Response;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Severity;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.NONE, classes={TestApplication.class})
@EnableAutoConfiguration
class ConvenienceCommunicationSubmitDocumentTest
extends XdsTestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ConvenienceCommunicationSubmitDocumentTest.class.getName());
    @Autowired
    private ConvenienceCommunication convenienceCommunication;
    private final String applicationName = "2.16.840.1.113883.3.72.6.5.100.1399";
    private final String facilityName;
    private final String senderApplicationOid = "1.2.3.4";
    private AffinityDomain affinityDomain = null;

    ConvenienceCommunicationSubmitDocumentTest() {
        this.facilityName = null;
    }

    @BeforeEach
    public void setUp() throws Exception {
        SpringApplication app = new SpringApplication(new Class[]{TestApplication.class});
        app.setWebApplicationType(WebApplicationType.NONE);
        app.run(new String[0]);
        this.affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        try {
            dest.setUri(new URI("http://ehealthsuisse.ihe-europe.net:8280/xdstools7/sim/epr-testing__for_init_gw_testing/rep/prb"));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("2.16.840.1.113883.3.72.6.5.100.1399");
        dest.setReceiverFacilityOid(this.facilityName);
        this.affinityDomain.setRegistryDestination(dest);
        this.affinityDomain.setRepositoryDestination(dest);
        this.convenienceCommunication.clearDocuments();
    }

    @Test
    void contextLoads() {
        Assertions.assertNotNull((Object)this.convenienceCommunication);
        Assertions.assertNotNull((Object)this.convenienceCommunication.getCamelContext());
    }

    @Test
    void submitPdfDocTest() throws Exception {
        this.convenienceCommunication.setAffinityDomain(this.affinityDomain);
        this.convenienceCommunication.clearDocuments();
        DocumentMetadata metdata = this.convenienceCommunication.addDocument(DocumentDescriptor.PDF, this.getDocPdf());
        SubmissionSetMetadata subSet = new SubmissionSetMetadata();
        Identificator patientId = new Identificator("1.3.6.1.4.1.21367.13.20.1000", "IHERED-1024");
        this.setMetadataForPdf(metdata, patientId);
        this.setSubmissionMetadata(subSet, patientId);
        Response response = this.convenienceCommunication.submit(subSet, null, null);
        Assertions.assertTrue((boolean)response.getErrors().isEmpty());
        Assertions.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
    }

    @Test
    void submitCdaDocTest() throws Exception {
        this.convenienceCommunication.setAffinityDomain(this.affinityDomain);
        this.convenienceCommunication.clearDocuments();
        DocumentMetadata metdata = this.convenienceCommunication.addDocument(DocumentDescriptor.CDA_R2, this.getDocCda());
        SubmissionSetMetadata subSet = new SubmissionSetMetadata();
        Identificator patientId = new Identificator("1.3.6.1.4.1.21367.13.20.3000", "IHEBLUE-2599");
        this.setMetadataForCda(metdata, patientId);
        this.setSubmissionMetadata(subSet, patientId);
        Response response = this.convenienceCommunication.submit(subSet, null, null);
        Assertions.assertTrue((boolean)response.getErrors().isEmpty());
        Assertions.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
    }

    @Test
    void submitDocumentWrongMetadataTest() throws Exception {
        this.convenienceCommunication.setAffinityDomain(this.affinityDomain);
        this.convenienceCommunication.clearDocuments();
        DocumentMetadata metdata = this.convenienceCommunication.addDocument(DocumentDescriptor.CDA_R2, this.getDocCda());
        SubmissionSetMetadata subSet = new SubmissionSetMetadata();
        Identificator patientId = new Identificator("1.3.6.1.4.1.21367.13.20.3000", "IHEBLUE-1043");
        this.setMetadataForCda(metdata, patientId);
        metdata.setClassCode(new Code("1", "1.2.3.4.5", "display"));
        this.setSubmissionMetadata(subSet, patientId);
        Response response = this.convenienceCommunication.submit(subSet, null, null);
        Assertions.assertEquals((Object)Status.FAILURE, (Object)response.getStatus());
        Assertions.assertTrue((response.getErrors().size() > 0 ? 1 : 0) != 0);
        ErrorInfo error = (ErrorInfo)response.getErrors().get(0);
        Assertions.assertEquals((Object)ErrorCode.REGISTRY_METADATA_ERROR, (Object)error.getErrorCode());
        Assertions.assertEquals((Object)"CodeValidation", (Object)error.getLocation());
        Assertions.assertEquals((Object)Severity.ERROR, (Object)error.getSeverity());
    }

    @Test
    void replaceCdaDocTest() throws Exception {
        this.convenienceCommunication.setAffinityDomain(this.affinityDomain);
        this.convenienceCommunication.clearDocuments();
        DocumentMetadata metdata = this.convenienceCommunication.addDocument(DocumentDescriptor.CDA_R2, this.getDocCda());
        SubmissionSetMetadata subSet = new SubmissionSetMetadata();
        Identificator patientId = new Identificator("1.3.6.1.4.1.21367.13.20.3000", "IHEBLUE-1043");
        this.setMetadataForCda(metdata, patientId);
        this.setSubmissionMetadata(subSet, patientId);
        Response response = this.convenienceCommunication.submit(subSet, null, null);
        String entryUuid = ((Document)this.convenienceCommunication.getTxnData().getDocuments().get(0)).getDocumentEntry().getEntryUuid();
        Assertions.assertTrue((boolean)response.getErrors().isEmpty());
        Assertions.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
        this.convenienceCommunication.clearDocuments();
        metdata = this.convenienceCommunication.addDocument(DocumentDescriptor.CDA_R2, this.getDocCdaV2());
        subSet = new SubmissionSetMetadata();
        patientId = new Identificator("1.3.6.1.4.1.21367.13.20.3000", "IHEBLUE-1043");
        this.setMetadataForCda(metdata, patientId);
        this.setSubmissionMetadata(subSet, patientId);
        response = this.convenienceCommunication.submitReplacement(subSet, entryUuid, null, null);
        Assertions.assertTrue((boolean)response.getErrors().isEmpty());
        Assertions.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
    }
}

