/*
 * Decompiled with CFR 0.152.
 */
package org.husky.communication.integration;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import org.husky.common.communication.AffinityDomain;
import org.husky.common.communication.Destination;
import org.husky.communication.ConvenienceCommunication;
import org.husky.communication.DocumentRequest;
import org.husky.communication.testhelper.TestApplication;
import org.husky.communication.testhelper.XdsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.openehealth.ipf.commons.ihe.xds.core.responses.ErrorCode;
import org.openehealth.ipf.commons.ihe.xds.core.responses.ErrorInfo;
import org.openehealth.ipf.commons.ihe.xds.core.responses.RetrievedDocument;
import org.openehealth.ipf.commons.ihe.xds.core.responses.RetrievedDocumentSet;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Severity;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.NONE, classes={TestApplication.class})
@EnableAutoConfiguration
class ConvenienceCommunicationRetrieveDocumentsTest
extends XdsTestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ConvenienceCommunicationRetrieveDocumentsTest.class.getName());
    @Autowired
    private ConvenienceCommunication convenienceCommunication;
    private final String applicationName = "2.16.840.1.113883.3.72.6.5.100.1399";
    private final String facilityName;
    private final String senderApplicationOid = "1.2.3.4";

    ConvenienceCommunicationRetrieveDocumentsTest() {
        this.facilityName = null;
    }

    @Test
    void contextLoads() {
        Assertions.assertNotNull((Object)this.convenienceCommunication);
        Assertions.assertNotNull((Object)this.convenienceCommunication.getCamelContext());
    }

    @Test
    void retrieveDocumentTest() throws Exception {
        AffinityDomain affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        try {
            dest.setUri(new URI("http://ehealthsuisse.ihe-europe.net:8280/xdstools7/sim/epr-testing__for_init_gw_testing/rep/ret"));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("2.16.840.1.113883.3.72.6.5.100.1399");
        dest.setReceiverFacilityOid(this.facilityName);
        affinityDomain.setRegistryDestination(dest);
        affinityDomain.setRepositoryDestination(dest);
        this.convenienceCommunication.setAffinityDomain(affinityDomain);
        DocumentRequest documentRequest = new DocumentRequest("1.1.4567332.1.75", null, "1.2.820.99999.15031207481211484821638086641062503555190193702785", "urn:oid:1.1.4567334.1.6");
        RetrievedDocumentSet response = this.convenienceCommunication.retrieveDocument(documentRequest, null, String.format("test_%s", UUID.randomUUID().toString()));
        Assertions.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
        Assertions.assertTrue((boolean)response.getErrors().isEmpty());
        Assertions.assertFalse((boolean)response.getDocuments().isEmpty());
        Assertions.assertEquals((int)1, (int)response.getDocuments().size());
        RetrievedDocument retrievedDocument = (RetrievedDocument)response.getDocuments().get(0);
        Assertions.assertEquals((Object)"application/pdf", (Object)retrievedDocument.getMimeType());
        try (InputStream is = retrievedDocument.getDataHandler().getInputStream();){
            byte[] bytesOfDocument = is.readAllBytes();
            Assertions.assertNotNull((Object)bytesOfDocument);
        }
    }

    @Test
    void retrieveDocumentCdaTest() throws Exception {
        AffinityDomain affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        try {
            dest.setUri(new URI("http://ehealthsuisse.ihe-europe.net:8280/xdstools7/sim/epr-testing__for_init_gw_testing/rep/ret"));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("2.16.840.1.113883.3.72.6.5.100.1399");
        dest.setReceiverFacilityOid(this.facilityName);
        affinityDomain.setRegistryDestination(dest);
        affinityDomain.setRepositoryDestination(dest);
        this.convenienceCommunication.setAffinityDomain(affinityDomain);
        DocumentRequest documentRequest = new DocumentRequest("1.1.4567332.1.75", null, "1.2.820.99999.18508463736145106181926975526539403561455330316563", "urn:oid:1.1.4567334.1.6");
        RetrievedDocumentSet response = this.convenienceCommunication.retrieveDocument(documentRequest, null, null);
        Assertions.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
        Assertions.assertTrue((boolean)response.getErrors().isEmpty());
        Assertions.assertFalse((boolean)response.getDocuments().isEmpty());
        Assertions.assertEquals((int)1, (int)response.getDocuments().size());
        RetrievedDocument retrievedDocument = (RetrievedDocument)response.getDocuments().get(0);
        Assertions.assertEquals((Object)"text/xml", (Object)retrievedDocument.getMimeType());
        try (InputStream is = retrievedDocument.getDataHandler().getInputStream();){
            byte[] bytesOfDocument = is.readAllBytes();
            Assertions.assertNotNull((Object)bytesOfDocument);
        }
    }

    @Test
    void retrieveDocumentUnknownIdTest() throws Exception {
        AffinityDomain affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        try {
            dest.setUri(new URI("http://ehealthsuisse.ihe-europe.net:8280/xdstools7/sim/epr-testing__for_init_gw_testing/rep/ret"));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("2.16.840.1.113883.3.72.6.5.100.1399");
        dest.setReceiverFacilityOid(this.facilityName);
        affinityDomain.setRegistryDestination(dest);
        affinityDomain.setRepositoryDestination(dest);
        this.convenienceCommunication.setAffinityDomain(affinityDomain);
        DocumentRequest documentRequest = new DocumentRequest("1", null, "1", "1");
        RetrievedDocumentSet response = this.convenienceCommunication.retrieveDocument(documentRequest, null, null);
        Assertions.assertEquals((Object)Status.FAILURE, (Object)response.getStatus());
        Assertions.assertTrue((response.getErrors().size() > 0 ? 1 : 0) != 0);
        ErrorInfo error = (ErrorInfo)response.getErrors().get(0);
        Assertions.assertEquals((Object)ErrorCode.DOCUMENT_UNIQUE_ID_ERROR, (Object)error.getErrorCode());
        Assertions.assertEquals((Object)"1", (Object)error.getLocation());
        Assertions.assertEquals((Object)Severity.ERROR, (Object)error.getSeverity());
    }
}

