/*
 * Decompiled with CFR 0.152.
 */
package org.husky.communication.integration;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.husky.common.communication.AffinityDomain;
import org.husky.common.communication.Destination;
import org.husky.common.model.Code;
import org.husky.common.model.Identificator;
import org.husky.common.model.Name;
import org.husky.common.model.Person;
import org.husky.communication.ConvenienceCommunication;
import org.husky.communication.testhelper.TestApplication;
import org.husky.communication.testhelper.XdsTestUtils;
import org.husky.communication.xd.storedquery.AbstractStoredQuery;
import org.husky.communication.xd.storedquery.FindDocumentsQuery;
import org.husky.communication.xd.storedquery.GetDocumentsQuery;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Author;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AvailabilityStatus;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntry;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.ObjectReference;
import org.openehealth.ipf.commons.ihe.xds.core.responses.ErrorCode;
import org.openehealth.ipf.commons.ihe.xds.core.responses.ErrorInfo;
import org.openehealth.ipf.commons.ihe.xds.core.responses.QueryResponse;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Severity;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.NONE, classes={TestApplication.class})
@EnableAutoConfiguration
class ConvenienceCommunicationQueryDocumentsTest
extends XdsTestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ConvenienceCommunicationQueryDocumentsTest.class.getName());
    @Autowired
    private ConvenienceCommunication convenienceCommunication;
    @Autowired
    protected AuditContext auditContext;
    private final String applicationName = "2.16.840.1.113883.3.72.6.5.100.1399";
    private final String facilityName;
    private final String senderApplicationOid = "1.2.3.4";
    private AffinityDomain affinityDomain = null;

    ConvenienceCommunicationQueryDocumentsTest() {
        this.facilityName = null;
    }

    @BeforeEach
    public void setUp() throws Exception {
        SpringApplication app = new SpringApplication(new Class[]{TestApplication.class});
        app.setWebApplicationType(WebApplicationType.NONE);
        app.run(new String[0]);
        this.affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        try {
            dest.setUri(new URI("http://ehealthsuisse.ihe-europe.net:8280/xdstools7/sim/epr-testing__for_init_gw_testing/rep/xcq"));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("2.16.840.1.113883.3.72.6.5.100.1399");
        dest.setReceiverFacilityOid(this.facilityName);
        this.affinityDomain.setRegistryDestination(dest);
        this.affinityDomain.setRepositoryDestination(dest);
    }

    @Test
    void contextLoads() {
        Assertions.assertNotNull((Object)this.convenienceCommunication);
        Assertions.assertNotNull((Object)this.convenienceCommunication.getCamelContext());
    }

    @Test
    void queryFindDocumentsEmptyResponseTest() throws Exception {
        Identificator patientId = new Identificator("1.3.6.1.4.1.21367.13.20.3000", "IHEBLUE-2737");
        FindDocumentsQuery findDocumentsQuery = new FindDocumentsQuery(patientId, AvailabilityStatus.APPROVED);
        this.convenienceCommunication.setAffinityDomain(this.affinityDomain);
        QueryResponse response = this.convenienceCommunication.queryDocuments((AbstractStoredQuery)findDocumentsQuery, null, null);
        Assertions.assertTrue((boolean)response.getErrors().isEmpty());
        Assertions.assertTrue((boolean)response.getDocuments().isEmpty());
        Assertions.assertTrue((boolean)response.getDocumentEntries().isEmpty());
        Assertions.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
    }

    @Test
    void queryFindDocumentsNoPatientIdExpectedErrorTest() throws Exception {
        FindDocumentsQuery findDocumentsQuery = new FindDocumentsQuery(null, AvailabilityStatus.APPROVED);
        this.convenienceCommunication.setAffinityDomain(this.affinityDomain);
        QueryResponse response = this.convenienceCommunication.queryDocuments((AbstractStoredQuery)findDocumentsQuery, null, null);
        Assertions.assertEquals((Object)Status.FAILURE, (Object)response.getStatus());
        Assertions.assertFalse((boolean)response.getErrors().isEmpty());
        Assertions.assertEquals((int)2, (int)response.getErrors().size());
        ErrorInfo error = (ErrorInfo)response.getErrors().get(0);
        Assertions.assertEquals((Object)ErrorCode.REGISTRY_ERROR, (Object)error.getErrorCode());
        Assertions.assertEquals((Object)"StoredQuery.java", (Object)error.getLocation());
        Assertions.assertEquals((Object)Severity.ERROR, (Object)error.getSeverity());
        error = (ErrorInfo)response.getErrors().get(1);
        Assertions.assertEquals((Object)ErrorCode.REGISTRY_ERROR, (Object)error.getErrorCode());
        Assertions.assertEquals((Object)"QueryRequestMessageValidator", (Object)error.getLocation());
        Assertions.assertEquals((Object)Severity.ERROR, (Object)error.getSeverity());
    }

    @Test
    void queryFindDocumentsMetadataOfPdf() throws Exception {
        Identificator patientId = new Identificator("1.3.6.1.4.1.21367.13.20.1000", "IHERED-1024");
        FindDocumentsQuery findDocumentsQuery = new FindDocumentsQuery(patientId, AvailabilityStatus.APPROVED);
        this.convenienceCommunication.setAffinityDomain(this.affinityDomain);
        QueryResponse response = this.convenienceCommunication.queryDocuments((AbstractStoredQuery)findDocumentsQuery, null, null);
        Assertions.assertTrue((boolean)response.getErrors().isEmpty());
        Assertions.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
        Assertions.assertTrue((response.getDocumentEntries().size() > 0 ? 1 : 0) != 0);
        DocumentEntry documentEntry = (DocumentEntry)response.getDocumentEntries().get(0);
        Assertions.assertEquals((Object)"1.2.820.99999.15031207481211484821638086641062503555190193702785", (Object)documentEntry.getUniqueId());
        Assertions.assertEquals((Object)"1.1.4567332.1.75", (Object)documentEntry.getRepositoryUniqueId());
        Assertions.assertEquals((Object)"urn:oid:1.1.4567334.1.6", (Object)documentEntry.getHomeCommunityId());
        Assertions.assertEquals((Object)"urn:uuid:b8f37101-8842-4e2c-b1e7-bc421d0dc01f", (Object)documentEntry.getEntryUuid());
        Assertions.assertEquals((Object)AvailabilityStatus.APPROVED, (Object)documentEntry.getAvailabilityStatus());
        Assertions.assertEquals((Object)"application/pdf", (Object)documentEntry.getMimeType());
        Assertions.assertNull((Object)documentEntry.getComments());
        Assertions.assertNull((Object)documentEntry.getDocumentAvailability());
        Assertions.assertEquals((Object)"Informed Consent", (Object)documentEntry.getTitle().getValue());
        Assertions.assertEquals((Object)"20211012082534", (Object)documentEntry.getCreationTime().toHL7());
        Assertions.assertEquals((Object)"de-CH", (Object)documentEntry.getLanguageCode());
        Assertions.assertNotNull((Object)documentEntry.getClassCode());
        Assertions.assertEquals((Object)"422735006", (Object)documentEntry.getClassCode().getCode());
        Assertions.assertEquals((Object)"2.16.840.1.113883.6.96", (Object)documentEntry.getClassCode().getSchemeName());
        Assertions.assertEquals((Object)"Summary clinical document (record artifact)", (Object)documentEntry.getClassCode().getDisplayName().getValue());
        Assertions.assertNotNull(documentEntry.getConfidentialityCodes().get(0));
        Assertions.assertEquals((Object)"17621005", (Object)((org.openehealth.ipf.commons.ihe.xds.core.metadata.Code)documentEntry.getConfidentialityCodes().get(0)).getCode());
        Assertions.assertEquals((Object)"Normal (qualifier value)", (Object)((org.openehealth.ipf.commons.ihe.xds.core.metadata.Code)documentEntry.getConfidentialityCodes().get(0)).getDisplayName().getValue());
        Assertions.assertTrue((boolean)documentEntry.getEventCodeList().isEmpty());
        Assertions.assertEquals((Object)"urn:ihe:iti:xds-sd:pdf:2008", (Object)documentEntry.getFormatCode().getCode());
        Assertions.assertEquals((Object)"1.3.6.1.4.1.19376.1.2.3", (Object)documentEntry.getFormatCode().getSchemeName());
        Assertions.assertEquals((Object)"1.3.6.1.4.1.19376.1.2.20 (Scanned Document)", (Object)documentEntry.getFormatCode().getDisplayName().getValue());
        Assertions.assertEquals((Object)"394747008", (Object)documentEntry.getHealthcareFacilityTypeCode().getCode());
        Assertions.assertEquals((Object)"2.16.840.1.113883.6.96", (Object)documentEntry.getHealthcareFacilityTypeCode().getSchemeName());
        Assertions.assertEquals((Object)"Health Authority", (Object)documentEntry.getHealthcareFacilityTypeCode().getDisplayName().getValue());
        Assertions.assertEquals((Object)"394810000", (Object)documentEntry.getPracticeSettingCode().getCode());
        Assertions.assertEquals((Object)"Rheumatology (qualifier value)", (Object)documentEntry.getPracticeSettingCode().getDisplayName().getValue());
        Assertions.assertEquals((Object)"2.16.840.1.113883.6.96", (Object)documentEntry.getPracticeSettingCode().getSchemeName());
        Assertions.assertEquals((Object)"371535009", (Object)documentEntry.getTypeCode().getCode());
        Assertions.assertEquals((Object)"Transfer summary report (record artifact)", (Object)documentEntry.getTypeCode().getDisplayName().getValue());
        Assertions.assertEquals((Object)"2.16.840.1.113883.6.96", (Object)documentEntry.getTypeCode().getSchemeName());
        Assertions.assertEquals((Object)"IHERED-1024", (Object)documentEntry.getPatientId().getId());
        Assertions.assertEquals((Object)"1.3.6.1.4.1.21367.13.20.1000", (Object)documentEntry.getPatientId().getAssigningAuthority().getUniversalId());
        Assertions.assertEquals((Object)"2342134localid", (Object)documentEntry.getSourcePatientId().getId());
        Assertions.assertEquals((Object)"1.2.3.4", (Object)documentEntry.getSourcePatientId().getAssigningAuthority().getUniversalId());
        Assertions.assertFalse((boolean)documentEntry.getAuthors().isEmpty());
        Assertions.assertNotNull(documentEntry.getAuthors().get(0));
        Assertions.assertNotNull((Object)((Author)documentEntry.getAuthors().get(0)).getAuthorPerson());
        Assertions.assertNotNull((Object)((Author)documentEntry.getAuthors().get(0)).getAuthorPerson().getName());
        Assertions.assertEquals((Object)"Bereit", (Object)((Author)documentEntry.getAuthors().get(0)).getAuthorPerson().getName().getFamilyName());
        Assertions.assertEquals((Object)"Allzeit", (Object)((Author)documentEntry.getAuthors().get(0)).getAuthorPerson().getName().getGivenName());
        Assertions.assertEquals((Object)"Dr.", (Object)((Author)documentEntry.getAuthors().get(0)).getAuthorPerson().getName().getPrefix());
        Assertions.assertNotNull((Object)((Author)documentEntry.getAuthors().get(0)).getAuthorRole());
        Assertions.assertNotNull(((Author)documentEntry.getAuthors().get(0)).getAuthorRole().get(0));
        Assertions.assertEquals((Object)"221", (Object)((Identifiable)((Author)documentEntry.getAuthors().get(0)).getAuthorRole().get(0)).getId());
        Assertions.assertEquals((Object)"2.16.840.1.113883.2.9.6.2.7", (Object)((Identifiable)((Author)documentEntry.getAuthors().get(0)).getAuthorRole().get(0)).getAssigningAuthority().getUniversalId());
        Assertions.assertNotNull((Object)((Author)documentEntry.getAuthors().get(0)).getAuthorSpecialty());
        Assertions.assertNotNull(((Author)documentEntry.getAuthors().get(0)).getAuthorSpecialty().get(0));
        Assertions.assertNull((Object)((Identifiable)((Author)documentEntry.getAuthors().get(0)).getAuthorSpecialty().get(0)).getId());
        Assertions.assertNull((Object)((Identifiable)((Author)documentEntry.getAuthors().get(0)).getAuthorSpecialty().get(0)).getAssigningAuthority().getUniversalId());
    }

    @Test
    void queryFindDocumentsMetadataOfCda() throws Exception {
        Identificator patientId = new Identificator("1.3.6.1.4.1.21367.13.20.3000", "IHEBLUE-2599");
        List<Code> classCodes = List.of(new Code("417319006", "2.16.840.1.113883.6.96", "Record of health event (record artifact)"));
        List<Code> practiceSettingCodes = List.of(new Code("394802001", "2.16.840.1.113883.6.96", "General medicine (qualifier value)"));
        List<Code> healthcareFacilityCodes = List.of(new Code("394747008", "2.16.840.1.113883.6.96", "Health Authority"));
        List<Code> confidentialityCodes = List.of(new Code("17621005", "2.16.840.1.113883.6.96", "Normal (qualifier value)"));
        List<Code> formatCodes = List.of(new Code("urn:ihe:pcc:ic:2009", "1.3.6.1.4.1.19376.1.2.3", "Immunization Content (IC)"));
        Person person = new Person();
        Name name = new Name();
        name.setFamily("Bereit");
        name.setGiven("Allzeit");
        name.setPrefix("Dr.");
        person.addName(name);
        FindDocumentsQuery findDocumentsQuery = new FindDocumentsQuery(patientId, classCodes, null, practiceSettingCodes, healthcareFacilityCodes, confidentialityCodes, formatCodes, person, AvailabilityStatus.APPROVED);
        this.convenienceCommunication.setAffinityDomain(this.affinityDomain);
        QueryResponse response = this.convenienceCommunication.queryDocuments((AbstractStoredQuery)findDocumentsQuery, null, null);
        Assertions.assertTrue((boolean)response.getErrors().isEmpty());
        Assertions.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
        Assertions.assertTrue((response.getDocumentEntries().size() > 0 ? 1 : 0) != 0);
        DocumentEntry documentEntry = (DocumentEntry)response.getDocumentEntries().get(0);
        Assertions.assertEquals((Object)"1.2.820.99999.18508463736145106181926975526539403561455330316563", (Object)documentEntry.getUniqueId());
        Assertions.assertEquals((Object)"1.1.4567332.1.75", (Object)documentEntry.getRepositoryUniqueId());
        Assertions.assertEquals((Object)"urn:oid:1.1.4567334.1.6", (Object)documentEntry.getHomeCommunityId());
        Assertions.assertEquals((Object)"urn:uuid:afd9bee4-4c30-4b58-a0e7-e301c799047b", (Object)documentEntry.getEntryUuid());
        Assertions.assertEquals((Object)AvailabilityStatus.APPROVED, (Object)documentEntry.getAvailabilityStatus());
        Assertions.assertEquals((Object)"text/xml", (Object)documentEntry.getMimeType());
        Assertions.assertNull((Object)documentEntry.getComments());
        Assertions.assertNull((Object)documentEntry.getDocumentAvailability());
        Assertions.assertNull((Object)documentEntry.getTitle());
        Assertions.assertEquals((Object)"20211012111457", (Object)documentEntry.getCreationTime().toHL7());
        Assertions.assertEquals((Object)"fr-CH", (Object)documentEntry.getLanguageCode());
        Assertions.assertNotNull((Object)documentEntry.getClassCode());
        Assertions.assertEquals((Object)"417319006", (Object)documentEntry.getClassCode().getCode());
        Assertions.assertEquals((Object)"2.16.840.1.113883.6.96", (Object)documentEntry.getClassCode().getSchemeName());
        Assertions.assertEquals((Object)"Record of health event (record artifact)", (Object)documentEntry.getClassCode().getDisplayName().getValue());
        Assertions.assertNotNull(documentEntry.getConfidentialityCodes().get(0));
        Assertions.assertEquals((Object)"17621005", (Object)((org.openehealth.ipf.commons.ihe.xds.core.metadata.Code)documentEntry.getConfidentialityCodes().get(0)).getCode());
        Assertions.assertEquals((Object)"Normal (qualifier value)", (Object)((org.openehealth.ipf.commons.ihe.xds.core.metadata.Code)documentEntry.getConfidentialityCodes().get(0)).getDisplayName().getValue());
        Assertions.assertTrue((boolean)documentEntry.getEventCodeList().isEmpty());
        Assertions.assertEquals((Object)"urn:ihe:pcc:ic:2009", (Object)documentEntry.getFormatCode().getCode());
        Assertions.assertEquals((Object)"1.3.6.1.4.1.19376.1.2.3", (Object)documentEntry.getFormatCode().getSchemeName());
        Assertions.assertEquals((Object)"Immunization Content (IC)", (Object)documentEntry.getFormatCode().getDisplayName().getValue());
        Assertions.assertEquals((Object)"394747008", (Object)documentEntry.getHealthcareFacilityTypeCode().getCode());
        Assertions.assertEquals((Object)"2.16.840.1.113883.6.96", (Object)documentEntry.getHealthcareFacilityTypeCode().getSchemeName());
        Assertions.assertEquals((Object)"Health Authority", (Object)documentEntry.getHealthcareFacilityTypeCode().getDisplayName().getValue());
        Assertions.assertEquals((Object)"394802001", (Object)documentEntry.getPracticeSettingCode().getCode());
        Assertions.assertEquals((Object)"General medicine (qualifier value)", (Object)documentEntry.getPracticeSettingCode().getDisplayName().getValue());
        Assertions.assertEquals((Object)"2.16.840.1.113883.6.96", (Object)documentEntry.getPracticeSettingCode().getSchemeName());
        Assertions.assertEquals((Object)"41000179103", (Object)documentEntry.getTypeCode().getCode());
        Assertions.assertEquals((Object)"Immunization record", (Object)documentEntry.getTypeCode().getDisplayName().getValue());
        Assertions.assertEquals((Object)"2.16.840.1.113883.6.96", (Object)documentEntry.getTypeCode().getSchemeName());
        Assertions.assertEquals((Object)"IHEBLUE-2599", (Object)documentEntry.getPatientId().getId());
        Assertions.assertEquals((Object)"1.3.6.1.4.1.21367.13.20.3000", (Object)documentEntry.getPatientId().getAssigningAuthority().getUniversalId());
        Assertions.assertEquals((Object)"23423452342134localid", (Object)documentEntry.getSourcePatientId().getId());
        Assertions.assertEquals((Object)"1.2.3.4", (Object)documentEntry.getSourcePatientId().getAssigningAuthority().getUniversalId());
        Assertions.assertFalse((boolean)documentEntry.getAuthors().isEmpty());
        Assertions.assertNotNull(documentEntry.getAuthors().get(0));
        Assertions.assertNotNull((Object)((Author)documentEntry.getAuthors().get(0)).getAuthorPerson());
        Assertions.assertNotNull((Object)((Author)documentEntry.getAuthors().get(0)).getAuthorPerson().getName());
        Assertions.assertEquals((Object)"Bereit", (Object)((Author)documentEntry.getAuthors().get(0)).getAuthorPerson().getName().getFamilyName());
        Assertions.assertEquals((Object)"Allzeit", (Object)((Author)documentEntry.getAuthors().get(0)).getAuthorPerson().getName().getGivenName());
        Assertions.assertEquals((Object)"Dr.", (Object)((Author)documentEntry.getAuthors().get(0)).getAuthorPerson().getName().getPrefix());
        Assertions.assertNotNull((Object)((Author)documentEntry.getAuthors().get(0)).getAuthorRole());
        Assertions.assertNotNull(((Author)documentEntry.getAuthors().get(0)).getAuthorRole().get(0));
        Assertions.assertEquals((Object)"221", (Object)((Identifiable)((Author)documentEntry.getAuthors().get(0)).getAuthorRole().get(0)).getId());
        Assertions.assertEquals((Object)"2.16.840.1.113883.2.9.6.2.7", (Object)((Identifiable)((Author)documentEntry.getAuthors().get(0)).getAuthorRole().get(0)).getAssigningAuthority().getUniversalId());
        Assertions.assertNotNull((Object)((Author)documentEntry.getAuthors().get(0)).getAuthorSpecialty());
        Assertions.assertNotNull(((Author)documentEntry.getAuthors().get(0)).getAuthorSpecialty().get(0));
        Assertions.assertNull((Object)((Identifiable)((Author)documentEntry.getAuthors().get(0)).getAuthorSpecialty().get(0)).getId());
        Assertions.assertNull((Object)((Identifiable)((Author)documentEntry.getAuthors().get(0)).getAuthorSpecialty().get(0)).getAssigningAuthority().getUniversalId());
    }

    @Test
    void queryGetDocumentsMetadataOfCda() throws Exception {
        LinkedList<String> uniqueIds = new LinkedList<String>();
        uniqueIds.add("1.2.820.99999.18508463736145106181926975526539403561455330316563");
        GetDocumentsQuery getDocumentsQuery = new GetDocumentsQuery(uniqueIds, false, "urn:oid:1.1.4567334.1.6");
        this.convenienceCommunication.setAffinityDomain(this.affinityDomain);
        QueryResponse response = this.convenienceCommunication.queryDocumentReferencesOnly((AbstractStoredQuery)getDocumentsQuery, null, String.format("urn:uuid:testMessage-%s", UUID.randomUUID().toString()));
        Assertions.assertTrue((boolean)response.getErrors().isEmpty());
        Assertions.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
        Assertions.assertTrue((response.getReferences().size() > 0 ? 1 : 0) != 0);
        ObjectReference objectRef = (ObjectReference)response.getReferences().iterator().next();
        Assertions.assertEquals((Object)"urn:uuid:afd9bee4-4c30-4b58-a0e7-e301c799047b", (Object)objectRef.getId());
        Assertions.assertEquals((Object)"urn:oid:1.1.4567334.1.6", (Object)objectRef.getHome());
    }
}

