/*
 * Decompiled with CFR 0.152.
 */
package org.husky.communication.integration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.LinkedList;
import org.husky.common.communication.AffinityDomain;
import org.husky.common.communication.AtnaConfig;
import org.husky.common.communication.Destination;
import org.husky.common.communication.DocumentMetadata;
import org.husky.common.communication.SubmissionSetMetadata;
import org.husky.common.enums.DocumentDescriptor;
import org.husky.common.model.Identificator;
import org.husky.communication.ConvenienceCommunication;
import org.husky.communication.DocumentRequest;
import org.husky.communication.testhelper.TestApplication;
import org.husky.communication.testhelper.XdsTestUtils;
import org.husky.communication.xd.storedquery.AbstractStoredQuery;
import org.husky.communication.xd.storedquery.GetDocumentsQuery;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.ObjectReference;
import org.openehealth.ipf.commons.ihe.xds.core.responses.QueryResponse;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Response;
import org.openehealth.ipf.commons.ihe.xds.core.responses.RetrievedDocument;
import org.openehealth.ipf.commons.ihe.xds.core.responses.RetrievedDocumentSet;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Status;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.NONE, classes={TestApplication.class})
@EnableAutoConfiguration
@ActiveProfiles(value={"atna"})
class ConvenienceCommunicationAtnaAuditTest
extends XdsTestUtils {
    @Autowired
    private ConvenienceCommunication convenienceCommunication;
    @Autowired
    protected AuditContext auditContext;
    private final String applicationName = "2.16.840.1.113883.3.72.6.5.100.1399";
    private final String facilityName;
    private final String senderApplicationOid = "1.2.3.4";

    ConvenienceCommunicationAtnaAuditTest() {
        this.facilityName = null;
    }

    @BeforeEach
    public void setUp() throws Exception {
        SpringApplication app = new SpringApplication(new Class[]{TestApplication.class});
        app.setWebApplicationType(WebApplicationType.NONE);
        app.run(new String[0]);
    }

    @Test
    void queryGetDocumentsMetadataOfCdaWithAuditMessage() throws Exception {
        AffinityDomain affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        try {
            dest.setUri(new URI("http://ehealthsuisse.ihe-europe.net:8280/xdstools7/sim/epr-testing__for_init_gw_testing/rep/xcq"));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("2.16.840.1.113883.3.72.6.5.100.1399");
        dest.setReceiverFacilityOid(this.facilityName);
        affinityDomain.setRegistryDestination(dest);
        affinityDomain.setRepositoryDestination(dest);
        this.convenienceCommunication.setAffinityDomain(affinityDomain);
        this.convenienceCommunication.setAtnaConfig(AtnaConfig.AtnaConfigMode.SECURE);
        LinkedList<String> uniqueIds = new LinkedList<String>();
        uniqueIds.add("1.2.820.99999.18508463736145106181926975526539403561455330316563");
        GetDocumentsQuery getDocumentsQuery = new GetDocumentsQuery(uniqueIds, false, "urn:oid:1.1.4567334.1.6");
        QueryResponse response = this.convenienceCommunication.queryDocumentReferencesOnly((AbstractStoredQuery)getDocumentsQuery, null, null);
        Assertions.assertTrue((boolean)response.getErrors().isEmpty());
        Assertions.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
        Assertions.assertTrue((!response.getReferences().isEmpty() ? 1 : 0) != 0);
        Assertions.assertTrue((response.getReferences().size() > 0 ? 1 : 0) != 0);
        ObjectReference objectRef = (ObjectReference)response.getReferences().iterator().next();
        Assertions.assertEquals((Object)"urn:uuid:afd9bee4-4c30-4b58-a0e7-e301c799047b", (Object)objectRef.getId());
        Assertions.assertEquals((Object)"urn:oid:1.1.4567334.1.6", (Object)objectRef.getHome());
        String logContent = this.checkAuditLogging();
        Assertions.assertTrue((boolean)logContent.contains("<EventID csd-code=\"110112\""));
        Assertions.assertTrue((boolean)logContent.contains("<EventTypeCode csd-code=\"ITI-18\""));
        Assertions.assertTrue((boolean)logContent.contains("RoleIDCode csd-code=\"110153\""));
        Assertions.assertTrue((boolean)logContent.contains("RoleIDCode csd-code=\"110152\""));
    }

    @Test
    void retrieveDocumentCdaTest() throws Exception {
        AffinityDomain affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        try {
            dest.setUri(new URI("http://ehealthsuisse.ihe-europe.net:8280/xdstools7/sim/epr-testing__for_init_gw_testing/rep/ret"));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("2.16.840.1.113883.3.72.6.5.100.1399");
        dest.setReceiverFacilityOid(this.facilityName);
        affinityDomain.setRegistryDestination(dest);
        affinityDomain.setRepositoryDestination(dest);
        this.convenienceCommunication.setAffinityDomain(affinityDomain);
        DocumentRequest documentRequest = new DocumentRequest("1.1.4567332.1.75", null, "1.2.820.99999.18508463736145106181926975526539403561455330316563", "urn:oid:1.1.4567334.1.6");
        RetrievedDocumentSet response = this.convenienceCommunication.retrieveDocument(documentRequest, null, null);
        Assertions.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
        Assertions.assertTrue((boolean)response.getErrors().isEmpty());
        Assertions.assertFalse((boolean)response.getDocuments().isEmpty());
        Assertions.assertEquals((int)1, (int)response.getDocuments().size());
        RetrievedDocument retrievedDocument = (RetrievedDocument)response.getDocuments().get(0);
        Assertions.assertEquals((Object)"text/xml", (Object)retrievedDocument.getMimeType());
        try (InputStream is = retrievedDocument.getDataHandler().getInputStream();){
            byte[] bytesOfDocument = is.readAllBytes();
            Assertions.assertNotNull((Object)bytesOfDocument);
            Assertions.assertTrue((bytesOfDocument.length > 0 ? 1 : 0) != 0);
        }
        String logContent = this.checkAuditLogging();
        Assertions.assertTrue((boolean)logContent.contains("<EventID csd-code=\"110107\""));
        Assertions.assertTrue((boolean)logContent.contains("<EventTypeCode csd-code=\"ITI-43\""));
    }

    @Test
    void submitPdfDocTest() throws Exception {
        AffinityDomain affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        try {
            dest.setUri(new URI("http://ehealthsuisse.ihe-europe.net:8280/xdstools7/sim/epr-testing__for_init_gw_testing/rep/prb"));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("2.16.840.1.113883.3.72.6.5.100.1399");
        dest.setReceiverFacilityOid(this.facilityName);
        affinityDomain.setRegistryDestination(dest);
        affinityDomain.setRepositoryDestination(dest);
        this.convenienceCommunication.setAffinityDomain(affinityDomain);
        this.convenienceCommunication.clearDocuments();
        DocumentMetadata metdata = this.convenienceCommunication.addDocument(DocumentDescriptor.PDF, this.getDocPdf());
        SubmissionSetMetadata subSet = new SubmissionSetMetadata();
        Identificator patientId = new Identificator("1.3.6.1.4.1.21367.13.20.3000", "IHEBLUE-1043");
        this.setMetadataForPdf(metdata, patientId);
        this.setSubmissionMetadata(subSet, patientId);
        Response response = this.convenienceCommunication.submit(subSet, null, null);
        Assertions.assertTrue((boolean)response.getErrors().isEmpty());
        Assertions.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
        String logContent = this.checkAuditLogging();
        Assertions.assertTrue((boolean)logContent.contains("<EventID csd-code=\"110106\""));
        Assertions.assertTrue((boolean)logContent.contains("<EventTypeCode csd-code=\"ITI-41\""));
    }

    private String checkAuditLogging() throws IOException {
        File originLogFile = new File("log/Spring-TestEHC.log");
        String logContent = new String(Files.readAllBytes(originLogFile.toPath()));
        Assertions.assertFalse((boolean)logContent.contains("Failed to send ATNA audit event to destination"));
        Assertions.assertTrue((boolean)logContent.contains("Auditing"));
        return logContent;
    }
}

