/*
 * Decompiled with CFR 0.152.
 */
package org.husky.communication.integration;

import java.io.InputStream;
import java.net.URI;
import java.util.UUID;
import org.husky.common.communication.AffinityDomain;
import org.husky.common.communication.Destination;
import org.husky.communication.ConvenienceCommunication;
import org.husky.communication.DocumentRequest;
import org.husky.communication.testhelper.TestApplication;
import org.husky.communication.testhelper.XdsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.openehealth.ipf.commons.ihe.xds.core.responses.RetrievedDocument;
import org.openehealth.ipf.commons.ihe.xds.core.responses.RetrievedDocumentSet;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.NONE, classes={TestApplication.class})
@EnableAutoConfiguration
class CHRetrieveDocumentsPGTest
extends XdsTestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CHRetrieveDocumentsPGTest.class.getName());
    @Autowired
    private ConvenienceCommunication convenienceCommunication;
    private final String applicationName = "2.16.840.1.113883.3.72.6.5.100.1399";
    private final String facilityName = "Waldpsital Bern";
    private final String senderApplicationOid = "1.2.3.4";
    final String documentId_1 = "2.25.90799173491713586491471839779315544798";
    final String repositoryId_1 = "1.1.1.2.31";
    final String homeCommunityId_1 = "urn:oid:1.1.1";
    final String documentId_2 = "2.25.253445961889251413523507992196901058285";
    final String repositoryId_2 = "1.1.1.2.31";
    final String homeCommunityId_2 = "urn:oid:1.1.1";

    CHRetrieveDocumentsPGTest() {
    }

    @Test
    void retrieveDocumentsTest() throws Exception {
        AffinityDomain affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        dest.setUri(new URI("https://epdplayground.i4mi.bfh.ch:6443/Repository/services/RepositoryService"));
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("2.16.840.1.113883.3.72.6.5.100.1399");
        dest.setReceiverFacilityOid("Waldpsital Bern");
        affinityDomain.setRegistryDestination(dest);
        affinityDomain.setRepositoryDestination(dest);
        this.convenienceCommunication.setAffinityDomain(affinityDomain);
        DocumentRequest documentRequest_1 = new DocumentRequest("1.1.1.2.31", null, "2.25.90799173491713586491471839779315544798", "urn:oid:1.1.1");
        DocumentRequest documentRequest_2 = new DocumentRequest("1.1.1.2.31", null, "2.25.253445961889251413523507992196901058285", "urn:oid:1.1.1");
        DocumentRequest[] documentRequests = new DocumentRequest[]{documentRequest_1, documentRequest_2};
        RetrievedDocumentSet response = this.convenienceCommunication.retrieveDocuments(documentRequests, null, String.format("test_%s", UUID.randomUUID().toString()));
        Assertions.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
        Assertions.assertTrue((boolean)response.getErrors().isEmpty());
        Assertions.assertFalse((boolean)response.getDocuments().isEmpty());
        Assertions.assertEquals((int)2, (int)response.getDocuments().size());
        for (RetrievedDocument retrievedDocument : response.getDocuments()) {
            Assertions.assertEquals((Object)"application/fhir+json", (Object)retrievedDocument.getMimeType());
            InputStream is = retrievedDocument.getDataHandler().getInputStream();
            try {
                byte[] bytesOfDocument = is.readAllBytes();
                Assertions.assertNotNull((Object)bytesOfDocument);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }
}

