/*
 * Decompiled with CFR 0.152.
 */
package org.husky.communication.integration;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.husky.common.communication.AffinityDomain;
import org.husky.common.communication.Destination;
import org.husky.common.model.Code;
import org.husky.common.model.Identificator;
import org.husky.communication.ConvenienceCommunication;
import org.husky.communication.testhelper.TestApplication;
import org.husky.communication.testhelper.XdsTestUtils;
import org.husky.communication.xd.storedquery.AbstractStoredQuery;
import org.husky.communication.xd.storedquery.FindDocumentsQuery;
import org.husky.xua.communication.clients.XuaClient;
import org.husky.xua.communication.clients.impl.ClientFactory;
import org.husky.xua.communication.config.XuaClientConfig;
import org.husky.xua.communication.config.impl.XuaClientConfigBuilderImpl;
import org.husky.xua.communication.xua.RequestType;
import org.husky.xua.communication.xua.TokenType;
import org.husky.xua.communication.xua.XUserAssertionRequest;
import org.husky.xua.communication.xua.XUserAssertionResponse;
import org.husky.xua.communication.xua.impl.XUserAssertionRequestBuilderImpl;
import org.husky.xua.core.SecurityHeaderElement;
import org.husky.xua.deserialization.impl.AssertionDeserializerImpl;
import org.husky.xua.hl7v3.CE;
import org.husky.xua.hl7v3.impl.CodedWithEquivalentImpl;
import org.husky.xua.hl7v3.impl.CodedWithEquivalentsBuilder;
import org.husky.xua.saml2.Assertion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AvailabilityStatus;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntry;
import org.openehealth.ipf.commons.ihe.xds.core.responses.QueryResponse;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Status;
import org.opensaml.core.config.InitializationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.NONE, classes={TestApplication.class})
@EnableAutoConfiguration
class CHRegistryStoredQueryTest
extends XdsTestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CHRegistryStoredQueryTest.class.getName());
    @Autowired
    private ConvenienceCommunication convenienceCommunication;
    @Autowired
    protected AuditContext auditContext;
    private final String applicationName = "2.16.840.1.113883.3.72.6.5.100.1399";
    private final String facilityName;
    private final String senderApplicationOid = "1.2.3.4";
    private AffinityDomain affinityDomain = null;
    final String globalAssigningAuthorityOid = "1.3.6.1.4.1.21367.13.20.1000";
    final String globalPatientId = "IHERED-1024";
    final String spidAssigningAuthorityOid = "2.16.756.5.30.1.127.3.10.3";
    final String spid = "761337610411265304";

    CHRegistryStoredQueryTest() {
        this.facilityName = null;
    }

    @BeforeEach
    public void setUp() throws Exception {
        InitializationService.initialize();
        SpringApplication app = new SpringApplication(new Class[]{TestApplication.class});
        app.setWebApplicationType(WebApplicationType.NONE);
        app.run(new String[0]);
        this.affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        dest.setUri(new URI("http://ehealthsuisse.ihe-europe.net:8280/xdstools7/sim/epr-testing__for_init_gw_testing/rep/xcq"));
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("2.16.840.1.113883.3.72.6.5.100.1399");
        dest.setReceiverFacilityOid(this.facilityName);
        this.affinityDomain.setRegistryDestination(dest);
        this.affinityDomain.setRepositoryDestination(dest);
    }

    @Test
    void queryFindDocuments() throws Exception {
        this.convenienceCommunication.setAffinityDomain(this.affinityDomain);
        Identificator globalId = new Identificator("1.3.6.1.4.1.21367.13.20.1000", "IHERED-1024");
        Code type = new Code("41000179103", "2.16.840.1.113883.6.96", "Immunization Record (record artifact)");
        Code clazz = new Code("184216000", "2.16.840.1.113883.6.96", "Patient record type (record artifact)");
        Code format = new Code("urn:che:epr:EPR_Unstructured_Document", "2.16.756.5.30.1.127.3.10.10", "Unstructured EPR document");
        FindDocumentsQuery findDocumentsQuery = new FindDocumentsQuery(globalId, AvailabilityStatus.APPROVED, type, clazz, format);
        Assertion xUserAssertion = this.getXUserAssertion();
        Assertions.assertNotNull((Object)xUserAssertion);
        QueryResponse response = this.convenienceCommunication.queryDocuments((AbstractStoredQuery)findDocumentsQuery, (SecurityHeaderElement)xUserAssertion, null);
        Assertions.assertTrue((boolean)response.getErrors().isEmpty());
        Assertions.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
        Assertions.assertTrue((response.getDocumentEntries().size() > 0 ? 1 : 0) != 0);
        LOGGER.info("**");
        LOGGER.info("Document Entry size is " + response.getDocumentEntries().size());
        DocumentEntry documentEntry = (DocumentEntry)response.getDocumentEntries().get(0);
        LOGGER.info("First document entry is " + documentEntry);
        LOGGER.info("**");
    }

    private Assertion getXUserAssertion() throws Exception {
        String urlToXua = "https://ehealthsuisse.ihe-europe.net:10443/STS?wsdl";
        String clientKeyStore = "src/test/resources/testKeystoreXua.jks";
        String clientKeyStorePass = "changeit";
        XuaClientConfig xuaClientConfig = new XuaClientConfigBuilderImpl().clientKeyStore("src/test/resources/testKeystoreXua.jks").clientKeyStorePassword("changeit").clientKeyStoreType("jks").url("https://ehealthsuisse.ihe-europe.net:10443/STS?wsdl").create();
        XuaClient client = ClientFactory.getXuaClient((XuaClientConfig)xuaClientConfig);
        try (FileInputStream is = new FileInputStream(new File("src/test/resources/IdPAssertionHCP.xml"));){
            Assertion idpAssertion = new AssertionDeserializerImpl().fromXmlByteArray(IOUtils.toByteArray((InputStream)is));
            CodedWithEquivalentImpl role = new CodedWithEquivalentsBuilder().code("HCP").codeSystem("2.16.756.5.30.1.127.3.10.6").displayName("Behandelnde(r)").buildObject("urn:hl7-org:v3", "Role", "hl7");
            CodedWithEquivalentImpl purposeOfUse = new CodedWithEquivalentsBuilder().code("NORM").codeSystem("2.16.756.5.30.1.127.3.10.6").displayName("Normal Access").buildObject("urn:hl7-org:v3", "PurposeOfUse", "hl7");
            String eprSpid = "761337610411265304^^^SPID&2.16.756.5.30.1.127.3.10.3&ISO";
            XUserAssertionRequest assertionRequest = new XUserAssertionRequestBuilderImpl().requestType(RequestType.WST_ISSUE).tokenType(TokenType.OASIS_WSS_SAML_PROFILE_11_SAMLV20).purposeOfUse((CE)purposeOfUse).subjectRole((CE)role).resourceId(eprSpid).create();
            List response = client.send((SecurityHeaderElement)idpAssertion, assertionRequest);
            Assertion assertion = ((XUserAssertionResponse)response.get(0)).getAssertion();
            return assertion;
        }
    }
}

