/*
 * Decompiled with CFR 0.152.
 */
package org.husky.communication.integration;

import java.net.URI;
import org.husky.common.communication.AffinityDomain;
import org.husky.common.communication.Destination;
import org.husky.common.model.Code;
import org.husky.common.model.Identificator;
import org.husky.communication.ConvenienceCommunication;
import org.husky.communication.testhelper.TestApplication;
import org.husky.communication.testhelper.XdsTestUtils;
import org.husky.communication.xd.storedquery.AbstractStoredQuery;
import org.husky.communication.xd.storedquery.FindDocumentsQuery;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AvailabilityStatus;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntry;
import org.openehealth.ipf.commons.ihe.xds.core.responses.QueryResponse;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Status;
import org.opensaml.core.config.InitializationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.NONE, classes={TestApplication.class})
@EnableAutoConfiguration
class CHRegistryStoredQueryPGTest
extends XdsTestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CHRegistryStoredQueryPGTest.class.getName());
    @Autowired
    private ConvenienceCommunication convenienceCommunication;
    @Autowired
    protected AuditContext auditContext;
    private final String applicationName = "2.16.840.1.113883.3.72.6.5.100.1399";
    private final String facilityName;
    private final String senderApplicationOid = "1.2.3.4";
    private AffinityDomain affinityDomain = null;
    final String localAssigningAuthorityOid = "1.2.3.4.123456.1";
    final String localPatientId = "waldspital-Id-1234";
    final String globalAssigningAuthorityOid = "1.1.1.99.1";
    final String globalPatientId = "2dc7a783-78b1-4627-94fb-610a23135c42";

    CHRegistryStoredQueryPGTest() {
        this.facilityName = null;
    }

    @BeforeEach
    public void setUp() throws Exception {
        InitializationService.initialize();
        SpringApplication app = new SpringApplication(new Class[]{TestApplication.class});
        app.setWebApplicationType(WebApplicationType.NONE);
        app.run(new String[0]);
        this.affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        dest.setUri(new URI("https://epdplayground.i4mi.bfh.ch:7443/Registry/services/RegistryService"));
        dest.setSenderApplicationOid("1.2.3.4");
        dest.setReceiverApplicationOid("2.16.840.1.113883.3.72.6.5.100.1399");
        dest.setReceiverFacilityOid(this.facilityName);
        this.affinityDomain.setRegistryDestination(dest);
        this.affinityDomain.setRepositoryDestination(dest);
    }

    @Test
    void queryFindDocuments() throws Exception {
        this.convenienceCommunication.setAffinityDomain(this.affinityDomain);
        Identificator globalId = new Identificator("1.1.1.99.1", "2dc7a783-78b1-4627-94fb-610a23135c42");
        Code type = new Code("41000179103", "2.16.840.1.113883.6.96", "Immunization Record (record artifact)");
        Code clazz = new Code("184216000", "2.16.840.1.113883.6.96", "Patient record type (record artifact)");
        Code format = new Code("urn:che:epr:EPR_Unstructured_Document", "2.16.756.5.30.1.127.3.10.10", "Unstructured EPR document");
        FindDocumentsQuery findDocumentsQuery = new FindDocumentsQuery(globalId, AvailabilityStatus.APPROVED, type, clazz, format);
        QueryResponse response = this.convenienceCommunication.queryDocuments((AbstractStoredQuery)findDocumentsQuery, null, null);
        Assertions.assertTrue((boolean)response.getErrors().isEmpty());
        Assertions.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
        Assertions.assertTrue((response.getDocumentEntries().size() > 0 ? 1 : 0) != 0);
        LOGGER.info("**");
        LOGGER.info("Document Entry size is " + response.getDocumentEntries().size());
        for (DocumentEntry entry : response.getDocumentEntries()) {
            LOGGER.info("documentId = " + entry.getUniqueId());
            LOGGER.info("repositoryUniqueId = " + entry.getRepositoryUniqueId());
            LOGGER.info("homeCommunityId = " + entry.getHomeCommunityId());
            LOGGER.info("");
        }
        LOGGER.info("**");
    }
}

