/*
 * Decompiled with CFR 0.152.
 */
package org.husky.communication.integration;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.husky.common.basetypes.NameBaseType;
import org.husky.common.communication.AffinityDomain;
import org.husky.common.communication.Destination;
import org.husky.common.communication.DocumentMetadata;
import org.husky.common.communication.SubmissionSetMetadata;
import org.husky.common.enums.DocumentDescriptor;
import org.husky.common.enums.EhcVersions;
import org.husky.common.model.Author;
import org.husky.common.model.Code;
import org.husky.common.model.Identificator;
import org.husky.common.model.Name;
import org.husky.communication.ConvenienceCommunication;
import org.husky.communication.testhelper.TestApplication;
import org.husky.communication.testhelper.XdsTestUtils;
import org.husky.xua.communication.clients.XuaClient;
import org.husky.xua.communication.clients.impl.ClientFactory;
import org.husky.xua.communication.config.XuaClientConfig;
import org.husky.xua.communication.config.impl.XuaClientConfigBuilderImpl;
import org.husky.xua.communication.xua.RequestType;
import org.husky.xua.communication.xua.TokenType;
import org.husky.xua.communication.xua.XUserAssertionRequest;
import org.husky.xua.communication.xua.XUserAssertionResponse;
import org.husky.xua.communication.xua.impl.XUserAssertionRequestBuilderImpl;
import org.husky.xua.core.SecurityHeaderElement;
import org.husky.xua.deserialization.impl.AssertionDeserializerImpl;
import org.husky.xua.hl7v3.CE;
import org.husky.xua.hl7v3.impl.CodedWithEquivalentImpl;
import org.husky.xua.hl7v3.impl.CodedWithEquivalentsBuilder;
import org.husky.xua.saml2.Assertion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.openehealth.ipf.commons.core.OidGenerator;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Response;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Status;
import org.opensaml.core.config.InitializationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.NONE, classes={TestApplication.class})
@EnableAutoConfiguration
class CHProvideAndRegisterDocumentSetTest
extends XdsTestUtils {
    static final Logger LOGGER = LoggerFactory.getLogger((String)CHProvideAndRegisterDocumentSetTest.class.getName());
    @Autowired
    private ConvenienceCommunication convenienceCommunication;
    private AffinityDomain affinityDomain = null;
    final String localAssigningAuthorityOid = "1.2.3.4.123456.1";
    final String localPatientId = "waldspital-Id-1234";
    final String globalAssigningAuthorityOid = "1.3.6.1.4.1.21367.13.20.1000";
    final String globalPatientId = "IHERED-1024";
    final String spidAssigningAuthorityOid = "2.16.756.5.30.1.127.3.10.3";
    final String spid = "761337610411265304";

    CHProvideAndRegisterDocumentSetTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        InitializationService.initialize();
        SpringApplication app = new SpringApplication(new Class[]{TestApplication.class});
        app.setWebApplicationType(WebApplicationType.NONE);
        app.run(new String[0]);
        Destination dest = new Destination();
        String repositoryURL = "http://ehealthsuisse.ihe-europe.net:8280/xdstools7/sim/epr-testing__for_init_gw_testing/rep/prb";
        dest.setUri(new URI("http://ehealthsuisse.ihe-europe.net:8280/xdstools7/sim/epr-testing__for_init_gw_testing/rep/prb"));
        String senderApplicationOid = "1.2.3.4";
        dest.setSenderApplicationOid("1.2.3.4");
        String applicationName = "Clinical Information System";
        dest.setReceiverApplicationOid("Clinical Information System");
        String facilityName = "Hospital in Bern";
        dest.setReceiverFacilityOid("Hospital in Bern");
        this.affinityDomain = new AffinityDomain();
        this.affinityDomain.setRegistryDestination(dest);
        this.affinityDomain.setRepositoryDestination(dest);
        this.convenienceCommunication.clearDocuments();
    }

    @Test
    void submitJSONDocumentTest() throws Exception {
        this.convenienceCommunication.setAffinityDomain(this.affinityDomain);
        this.convenienceCommunication.clearDocuments();
        File file = new File("src/test/resources/docSource/FHIR-Vaccination.json");
        DocumentMetadata documentMetadata = this.convenienceCommunication.addDocument(DocumentDescriptor.FHIR_JSON, (InputStream)new FileInputStream(file));
        documentMetadata.setTitle("Impfung");
        Name name = new Name(new NameBaseType());
        name.setGiven("Peter");
        name.setFamily("M\u00fcller");
        name.setPrefix("Dr. med");
        Author author = new Author();
        author.addName(name);
        Code role = new Code("HCP", "2.16.756.5.30.1.127.3.10.6", "Healthcare professional");
        author.setRoleFunction(role);
        documentMetadata.addAuthor(author);
        Identificator globalId = new Identificator("1.3.6.1.4.1.21367.13.20.1000", "IHERED-1024");
        documentMetadata.setDestinationPatientId(globalId);
        Identificator localId = new Identificator("1.2.3.4.123456.1", "waldspital-Id-1234");
        documentMetadata.setSourcePatientId(localId);
        documentMetadata.setCodedLanguage("de-CH");
        Code type = new Code("41000179103", "2.16.840.1.113883.6.96", "Immunization Record (record artifact)");
        documentMetadata.setTypeCode(type);
        Code format = new Code("urn:che:epr:EPR_Unstructured_Document", "2.16.756.5.30.1.127.3.10.10", "Unstructured EPR document");
        documentMetadata.setFormatCode(format);
        Code clazz = new Code("184216000", "2.16.840.1.113883.6.96", "Patient record type (record artifact)");
        documentMetadata.setClassCode(clazz);
        Code facility = new Code("22232009", "2.16.840.1.113883.6.96", "Hospital (environment)");
        documentMetadata.setHealthcareFacilityTypeCode(facility);
        Code practice = new Code("394802001", "2.16.840.1.113883.6.96", "General medicine (qualifier value)");
        documentMetadata.setPracticeSettingCode(practice);
        Code confidentiality = new Code("17621005", "2.16.840.1.113883.6.96", "Normal");
        documentMetadata.addConfidentialityCode(confidentiality);
        SubmissionSetMetadata submissionSetMetadata = new SubmissionSetMetadata();
        submissionSetMetadata.setUniqueId(OidGenerator.uniqueOid().toString());
        submissionSetMetadata.setSourceId(EhcVersions.getCurrentVersion().getOid());
        submissionSetMetadata.setEntryUUID(UUID.randomUUID().toString());
        submissionSetMetadata.setDestinationPatientId(globalId);
        submissionSetMetadata.getAuthor().add(authorPerson);
        Code contentType = new Code("71388002", "2.16.840.1.113883.6.96", "Procedure (procedure)");
        submissionSetMetadata.setContentTypeCode(contentType);
        submissionSetMetadata.setAuthor(author);
        Assertion xUserAssertion = this.getXUserAssertion();
        Assertions.assertNotNull((Object)xUserAssertion);
        Response response = this.convenienceCommunication.submit(submissionSetMetadata, (SecurityHeaderElement)xUserAssertion, null);
        Assertions.assertTrue((boolean)response.getErrors().isEmpty());
        Assertions.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
    }

    private Assertion getXUserAssertion() throws Exception {
        String urlToXua = "https://ehealthsuisse.ihe-europe.net:10443/STS?wsdl";
        String clientKeyStore = "src/test/resources/testKeystoreXua.jks";
        String clientKeyStorePass = "changeit";
        XuaClientConfig xuaClientConfig = new XuaClientConfigBuilderImpl().clientKeyStore("src/test/resources/testKeystoreXua.jks").clientKeyStorePassword("changeit").clientKeyStoreType("jks").url("https://ehealthsuisse.ihe-europe.net:10443/STS?wsdl").create();
        XuaClient client = ClientFactory.getXuaClient((XuaClientConfig)xuaClientConfig);
        try (FileInputStream is = new FileInputStream(new File("src/test/resources/IdPAssertionHCP.xml"));){
            Assertion idpAssertion = new AssertionDeserializerImpl().fromXmlByteArray(IOUtils.toByteArray((InputStream)is));
            CodedWithEquivalentImpl role = new CodedWithEquivalentsBuilder().code("HCP").codeSystem("2.16.756.5.30.1.127.3.10.6").displayName("Behandelnde(r)").buildObject("urn:hl7-org:v3", "Role", "hl7");
            CodedWithEquivalentImpl purposeOfUse = new CodedWithEquivalentsBuilder().code("NORM").codeSystem("2.16.756.5.30.1.127.3.10.6").displayName("Normal Access").buildObject("urn:hl7-org:v3", "PurposeOfUse", "hl7");
            String eprSpid = "761337610411265304^^^SPID&2.16.756.5.30.1.127.3.10.3&ISO";
            XUserAssertionRequest assertionRequest = new XUserAssertionRequestBuilderImpl().requestType(RequestType.WST_ISSUE).tokenType(TokenType.OASIS_WSS_SAML_PROFILE_11_SAMLV20).purposeOfUse((CE)purposeOfUse).subjectRole((CE)role).resourceId(eprSpid).create();
            List response = client.send((SecurityHeaderElement)idpAssertion, assertionRequest);
            Assertion assertion = ((XUserAssertionResponse)response.get(0)).getAssertion();
            return assertion;
        }
    }
}

