/*
 * Decompiled with CFR 0.152.
 */
package org.husky.communication.integration;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.husky.common.basetypes.NameBaseType;
import org.husky.common.communication.AffinityDomain;
import org.husky.common.communication.Destination;
import org.husky.common.communication.DocumentMetadata;
import org.husky.common.communication.SubmissionSetMetadata;
import org.husky.common.enums.DocumentDescriptor;
import org.husky.common.enums.EhcVersions;
import org.husky.common.model.Author;
import org.husky.common.model.Code;
import org.husky.common.model.Identificator;
import org.husky.common.model.Name;
import org.husky.communication.ConvenienceCommunication;
import org.husky.communication.testhelper.TestApplication;
import org.husky.communication.testhelper.XdsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.openehealth.ipf.commons.core.OidGenerator;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntry;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Response;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Status;
import org.opensaml.core.config.InitializationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.NONE, classes={TestApplication.class})
@EnableAutoConfiguration
class CHProvideAndRegisterDocumentSetPGTest
extends XdsTestUtils {
    static final Logger LOGGER = LoggerFactory.getLogger((String)CHProvideAndRegisterDocumentSetPGTest.class.getName());
    @Autowired
    private ConvenienceCommunication convenienceCommunication;
    private AffinityDomain affinityDomain = null;
    final String localAssigningAuthorityOid = "1.2.3.4.123456.1";
    final String localPatientId = "waldspital-Id-1234";
    final String globalAssigningAuthorityOid = "1.1.1.99.1";
    final String globalPatientId = "2dc7a783-78b1-4627-94fb-610a23135c42";

    CHProvideAndRegisterDocumentSetPGTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        InitializationService.initialize();
        SpringApplication app = new SpringApplication(new Class[]{TestApplication.class});
        app.setWebApplicationType(WebApplicationType.NONE);
        app.run(new String[0]);
        Destination dest = new Destination();
        String repositoryURL = "https://epdplayground.i4mi.bfh.ch:6443/Repository/services/RepositoryService";
        dest.setUri(new URI("https://epdplayground.i4mi.bfh.ch:6443/Repository/services/RepositoryService"));
        String senderApplicationOid = "1.2.3.4";
        dest.setSenderApplicationOid("1.2.3.4");
        String applicationName = "Clinical Information System";
        dest.setReceiverApplicationOid("Clinical Information System");
        String facilityName = "Waldspital Bern";
        dest.setReceiverFacilityOid("Waldspital Bern");
        this.affinityDomain = new AffinityDomain();
        this.affinityDomain.setRegistryDestination(dest);
        this.affinityDomain.setRepositoryDestination(dest);
        this.convenienceCommunication.clearDocuments();
    }

    @Test
    void submitJSONDocumentTest() throws Exception {
        this.convenienceCommunication.setAffinityDomain(this.affinityDomain);
        this.convenienceCommunication.clearDocuments();
        File file = new File("src/test/resources/docSource/FHIR-Vaccination.json");
        DocumentMetadata documentMetadata = this.convenienceCommunication.addDocument(DocumentDescriptor.FHIR_JSON, (InputStream)new FileInputStream(file));
        documentMetadata.setTitle("Impfung");
        String key = "urn:e-health-suisse:2020:originalProviderRole";
        String code = "HCP^^^&2.16.756.5.30.1.127.3.10.6&ISO";
        DocumentEntry xDoc = documentMetadata.getXDoc();
        HashMap<String, List<String>> extraMetadata = new HashMap<String, List<String>>();
        List<String> values = List.of(code);
        extraMetadata.put(key, values);
        xDoc.setExtraMetadata(extraMetadata);
        Name name = new Name(new NameBaseType());
        name.setGiven("Peter");
        name.setFamily("M\u00fcller");
        name.setPrefix("Dr. med");
        Author author = new Author();
        author.addName(name);
        Code role = new Code("HCP", "2.16.756.5.30.1.127.3.10.6", "Healthcare professional");
        author.setRoleFunction(role);
        documentMetadata.addAuthor(author);
        Identificator globalId = new Identificator("1.1.1.99.1", "2dc7a783-78b1-4627-94fb-610a23135c42");
        documentMetadata.setDestinationPatientId(globalId);
        Identificator localId = new Identificator("1.2.3.4.123456.1", "waldspital-Id-1234");
        documentMetadata.setSourcePatientId(localId);
        documentMetadata.setCodedLanguage("en");
        Code type = new Code("41000179103", "2.16.840.1.113883.6.96", "Immunization Record (record artifact)");
        documentMetadata.setTypeCode(type);
        Code format = new Code("urn:che:epr:EPR_Unstructured_Document", "2.16.756.5.30.1.127.3.10.10", "Unstructured EPR document");
        documentMetadata.setFormatCode(format);
        Code clazz = new Code("184216000", "2.16.840.1.113883.6.96", "Patient record type (record artifact)");
        documentMetadata.setClassCode(clazz);
        Code facility = new Code("22232009", "2.16.840.1.113883.6.96", "Hospital (environment)");
        documentMetadata.setHealthcareFacilityTypeCode(facility);
        Code practice = new Code("394802001", "2.16.840.1.113883.6.96", "General medicine (qualifier value)");
        documentMetadata.setPracticeSettingCode(practice);
        Code confidentiality = new Code("17621005", "2.16.840.1.113883.6.96", "Normal");
        documentMetadata.addConfidentialityCode(confidentiality);
        SubmissionSetMetadata submissionSetMetadata = new SubmissionSetMetadata();
        submissionSetMetadata.setUniqueId(OidGenerator.uniqueOid().toString());
        submissionSetMetadata.setSourceId(EhcVersions.getCurrentVersion().getOid());
        submissionSetMetadata.setEntryUUID(UUID.randomUUID().toString());
        submissionSetMetadata.setDestinationPatientId(globalId);
        Name providerName = new Name(new NameBaseType());
        providerName.setGiven("Gabriela");
        providerName.setFamily("Meier");
        providerName.setPrefix("Dr. med");
        Author provider = new Author();
        provider.addName(providerName);
        Code contentType = new Code("71388002", "2.16.840.1.113883.6.96", "Procedure (procedure)");
        submissionSetMetadata.setContentTypeCode(contentType);
        Response response = this.convenienceCommunication.submit(submissionSetMetadata, null, null);
        Assertions.assertTrue((boolean)response.getErrors().isEmpty());
        Assertions.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
    }
}

